/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.format.support;

import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.support.ConversionServiceFactory;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.datetime.joda.JodaTimeFormattingConfigurer;
import org.springframework.format.number.NumberFormatAnnotationFormatterFactory;
import org.springframework.format.number.NumberFormatter;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormattingConversionServiceFactoryBean
implements FactoryBean<FormattingConversionService>,
InitializingBean {
    private static final boolean jodaTimePresent = ClassUtils.isPresent((String)"org.joda.time.DateTime", (ClassLoader)FormattingConversionService.class.getClassLoader());
    private FormattingConversionService conversionService;

    public void afterPropertiesSet() {
        this.conversionService = new FormattingConversionService();
        ConversionServiceFactory.addDefaultConverters((GenericConversionService)this.conversionService);
        this.installFormatters(this.conversionService);
    }

    public FormattingConversionService getObject() {
        return this.conversionService;
    }

    public Class<? extends FormattingConversionService> getObjectType() {
        return FormattingConversionService.class;
    }

    public boolean isSingleton() {
        return true;
    }

    protected void installFormatters(FormatterRegistry registry) {
        registry.addFormatterForFieldType(Number.class, new NumberFormatter());
        registry.addFormatterForFieldAnnotation(new NumberFormatAnnotationFormatterFactory());
        if (jodaTimePresent) {
            new JodaTimeFormattingConfigurer().installJodaTimeFormatting(registry);
        }
    }
}

