/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.format.number;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.format.AnnotationFormatterFactory;
import org.springframework.format.Formatter;
import org.springframework.format.Parser;
import org.springframework.format.Printer;
import org.springframework.format.annotation.NumberFormat;
import org.springframework.format.number.CurrencyFormatter;
import org.springframework.format.number.NumberFormatter;
import org.springframework.format.number.PercentFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NumberFormatAnnotationFormatterFactory
implements AnnotationFormatterFactory<NumberFormat> {
    private final Set<Class<?>> fieldTypes = Collections.unmodifiableSet(this.createFieldTypes());

    @Override
    public Set<Class<?>> getFieldTypes() {
        return this.fieldTypes;
    }

    @Override
    public Printer<Number> getPrinter(NumberFormat annotation, Class<?> fieldType) {
        return this.configureFormatterFrom(annotation, fieldType);
    }

    @Override
    public Parser<Number> getParser(NumberFormat annotation, Class<?> fieldType) {
        return this.configureFormatterFrom(annotation, fieldType);
    }

    private Set<Class<?>> createFieldTypes() {
        HashSet fieldTypes = new HashSet(7);
        fieldTypes.add(Short.class);
        fieldTypes.add(Integer.class);
        fieldTypes.add(Long.class);
        fieldTypes.add(Float.class);
        fieldTypes.add(Double.class);
        fieldTypes.add(BigDecimal.class);
        fieldTypes.add(BigInteger.class);
        return fieldTypes;
    }

    private Formatter<Number> configureFormatterFrom(NumberFormat annotation, Class<?> fieldType) {
        if (!annotation.pattern().isEmpty()) {
            return new NumberFormatter(annotation.pattern());
        }
        NumberFormat.Style style = annotation.style();
        if (style == NumberFormat.Style.PERCENT) {
            return new PercentFormatter();
        }
        if (style == NumberFormat.Style.CURRENCY) {
            return new CurrencyFormatter();
        }
        return new NumberFormatter();
    }
}

