/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.util.Set;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConversionServiceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversionServiceFactoryBean
implements FactoryBean<ConversionService>,
InitializingBean {
    private Set<Object> converters;
    private ConversionService conversionService;

    public void setConverters(Set<Object> converters) {
        this.converters = converters;
    }

    public void afterPropertiesSet() {
        this.conversionService = this.createConversionService();
        this.registerConverters(this.converters, (ConverterRegistry)this.conversionService);
    }

    public ConversionService getObject() {
        return this.conversionService;
    }

    public Class<? extends ConversionService> getObjectType() {
        return ConversionService.class;
    }

    public boolean isSingleton() {
        return true;
    }

    protected ConversionService createConversionService() {
        return ConversionServiceFactory.createDefaultConversionService();
    }

    private void registerConverters(Set<Object> converters, ConverterRegistry registry) {
        if (converters != null) {
            for (Object converter : converters) {
                if (converter instanceof Converter) {
                    registry.addConverter((Converter)converter);
                    continue;
                }
                if (converter instanceof ConverterFactory) {
                    registry.addConverterFactory((ConverterFactory)converter);
                    continue;
                }
                if (converter instanceof GenericConverter) {
                    registry.addGenericConverter((GenericConverter)converter);
                    continue;
                }
                throw new IllegalArgumentException("Each converter must implement one of the Converter, ConverterFactory, or GenericConverter interfaces");
            }
        }
    }
}

