/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.beanvalidation;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.metadata.BeanDescriptor;
import org.springframework.util.Assert;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringValidatorAdapter
implements Validator,
javax.validation.Validator {
    private javax.validation.Validator targetValidator;

    public SpringValidatorAdapter(javax.validation.Validator targetValidator) {
        Assert.notNull((Object)targetValidator, (String)"Target Validator must not be null");
        this.targetValidator = targetValidator;
    }

    SpringValidatorAdapter() {
    }

    void setTargetValidator(javax.validation.Validator targetValidator) {
        this.targetValidator = targetValidator;
    }

    @Override
    public boolean supports(Class<?> clazz) {
        return true;
    }

    @Override
    public void validate(Object target, Errors errors) {
        Set result = this.targetValidator.validate(target, new Class[0]);
        for (ConstraintViolation violation : result) {
            errors.rejectValue(violation.getPropertyPath().toString(), ((Annotation)((Object)violation.getConstraintDescriptor().getAnnotation())).annotationType().getSimpleName(), violation.getConstraintDescriptor().getAttributes().values().toArray(), violation.getMessage());
        }
    }

    public <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups) {
        return this.targetValidator.validate(object, (Class[])groups);
    }

    public <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, Class<?> ... groups) {
        return this.targetValidator.validateProperty(object, propertyName, (Class[])groups);
    }

    public <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) {
        return this.targetValidator.validateValue(beanType, propertyName, groups, new Class[0]);
    }

    public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        return this.targetValidator.getConstraintsForClass(clazz);
    }

    public <T> T unwrap(Class<T> type) {
        return (T)this.targetValidator.unwrap(type);
    }
}

