/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ui.format.support;

import java.lang.annotation.Annotation;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.ui.format.AnnotationFormatterFactory;
import org.springframework.ui.format.Formatted;
import org.springframework.ui.format.Formatter;
import org.springframework.ui.format.FormatterRegistry;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericFormatterRegistry
implements FormatterRegistry,
ApplicationContextAware,
Cloneable {
    private final Map<Class, Formatter> typeFormatters = new ConcurrentHashMap<Class, Formatter>();
    private final Map<Class, AnnotationFormatterFactory> annotationFormatters = new ConcurrentHashMap<Class, AnnotationFormatterFactory>();
    private ConversionService conversionService = new DefaultConversionService();
    private ApplicationContext applicationContext;
    private boolean shared = true;

    public void setFormatters(Set<Formatter<?>> formatters) {
        for (Formatter<?> formatter : formatters) {
            this.addFormatterByType(formatter);
        }
    }

    public void setFormatterMap(Map<Class<?>, Formatter<?>> formatters) {
        for (Map.Entry<Class<?>, Formatter<?>> entry : formatters.entrySet()) {
            this.addFormatterByType(entry.getKey(), entry.getValue());
        }
    }

    public void setAnnotationFormatterMap(Map<Class<? extends Annotation>, Formatter<?>> formatters) {
        for (Map.Entry<Class<Annotation>, Formatter<?>> entry : formatters.entrySet()) {
            this.addFormatterByAnnotation(entry.getKey(), entry.getValue());
        }
    }

    public void setAnnotationFormatterFactories(Set<AnnotationFormatterFactory<?, ?>> factories) {
        for (AnnotationFormatterFactory<?, ?> factory : factories) {
            this.addFormatterByAnnotation(factory);
        }
    }

    public void setConversionService(ConversionService conversionService) {
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null");
        this.conversionService = conversionService;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    @Override
    public void setApplicationContext(ApplicationContext context) {
        if (this.conversionService == null && context.containsBean("conversionService")) {
            this.conversionService = (ConversionService)context.getBean("conversionService", ConversionService.class);
        }
        this.applicationContext = context;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public boolean isShared() {
        return this.shared;
    }

    public GenericFormatterRegistry clone() {
        GenericFormatterRegistry clone = new GenericFormatterRegistry();
        clone.typeFormatters.putAll(this.typeFormatters);
        clone.annotationFormatters.putAll(this.annotationFormatters);
        clone.conversionService = this.conversionService;
        clone.applicationContext = this.applicationContext;
        clone.shared = false;
        return clone;
    }

    @Override
    public void addFormatterByType(Class<?> type, Formatter<?> formatter) {
        Class formattedObjectType = GenericTypeResolver.resolveTypeArgument(formatter.getClass(), Formatter.class);
        if (!this.conversionService.canConvert(formattedObjectType, type)) {
            throw new IllegalArgumentException("Unable to register Formatter " + formatter + " for type [" + type.getName() + "]; not able to convert from [" + formattedObjectType.getName() + "] to parse");
        }
        if (!this.conversionService.canConvert(type, formattedObjectType)) {
            throw new IllegalArgumentException("Unable to register Formatter " + formatter + " for type [" + type.getName() + "]; not able to convert to [" + formattedObjectType.getName() + "] to format");
        }
        this.typeFormatters.put(type, formatter);
    }

    @Override
    public <T> void addFormatterByType(Formatter<T> formatter) {
        Class formattedObjectType = GenericTypeResolver.resolveTypeArgument(formatter.getClass(), Formatter.class);
        this.typeFormatters.put(formattedObjectType, formatter);
    }

    @Override
    public void addFormatterByAnnotation(Class<? extends Annotation> annotationType, Formatter<?> formatter) {
        this.annotationFormatters.put(annotationType, new SimpleAnnotationFormatterFactory(formatter));
    }

    @Override
    public <A extends Annotation, T> void addFormatterByAnnotation(AnnotationFormatterFactory<A, T> factory) {
        Class[] typeArgs = GenericTypeResolver.resolveTypeArguments(factory.getClass(), AnnotationFormatterFactory.class);
        if (typeArgs == null) {
            throw new IllegalArgumentException("Unable to extract Annotation type A argument from AnnotationFormatterFactory [" + factory.getClass().getName() + "]; does the factory parameterize the <A> generic type?");
        }
        this.annotationFormatters.put(typeArgs[0], factory);
    }

    @Override
    public <T> Formatter<T> getFormatter(Class<T> targetType) {
        return this.getFormatter(TypeDescriptor.valueOf(targetType));
    }

    @Override
    public Formatter<Object> getFormatter(TypeDescriptor type) {
        Assert.notNull((Object)type, (String)"TypeDescriptor is required");
        Formatter formatter = this.getAnnotationFormatter(type);
        if (formatter == null) {
            formatter = this.getTypeFormatter(type.getType());
        }
        if (formatter != null) {
            Class formattedObjectType = GenericTypeResolver.resolveTypeArgument(formatter.getClass(), Formatter.class);
            if (!type.getType().isAssignableFrom(formattedObjectType)) {
                return new ConvertingFormatter(type.getType(), formattedObjectType, formatter);
            }
        }
        return formatter;
    }

    private Formatter getAnnotationFormatter(TypeDescriptor type) {
        Annotation[] annotations;
        Annotation[] annotationArray = annotations = type.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation ann = annotationArray[n2];
            AnnotationFormatterFactory factory = this.annotationFormatters.get(ann.annotationType());
            if (factory != null) {
                return factory.getFormatter(ann);
            }
            Formatted formattedAnnotation = ann.annotationType().getAnnotation(Formatted.class);
            if (formattedAnnotation != null) {
                Formatter<?> formatter = this.createFormatter(formattedAnnotation.value());
                this.annotationFormatters.put(ann.annotationType(), new SimpleAnnotationFormatterFactory(formatter));
                return formatter;
            }
            ++n2;
        }
        return null;
    }

    private Formatter getTypeFormatter(Class<?> type) {
        Formatter<?> formatter = this.findFormatter(type);
        return formatter != null ? formatter : this.getDefaultFormatter(type);
    }

    private Formatter<?> findFormatter(Class<?> type) {
        LinkedList classQueue = new LinkedList();
        classQueue.addFirst(type);
        while (!classQueue.isEmpty()) {
            Class<?>[] interfaces;
            Class currentClass = (Class)classQueue.removeLast();
            Formatter formatter = this.typeFormatters.get(currentClass);
            if (formatter != null) {
                return formatter;
            }
            if (currentClass.getSuperclass() != null) {
                classQueue.addFirst(currentClass.getSuperclass());
            }
            Class<?>[] classArray = interfaces = currentClass.getInterfaces();
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> ifc = classArray[n2];
                classQueue.addFirst(ifc);
                ++n2;
            }
        }
        return null;
    }

    private Formatter<?> getDefaultFormatter(Class<?> type) {
        Formatted formatted = (Formatted)AnnotationUtils.findAnnotation(type, Formatted.class);
        if (formatted != null) {
            Formatter<?> formatter = this.createFormatter(formatted.value());
            this.typeFormatters.put(type, formatter);
            return formatter;
        }
        return null;
    }

    private Formatter<?> createFormatter(Class<? extends Formatter> formatterClass) {
        return this.applicationContext != null ? (Formatter)this.applicationContext.getAutowireCapableBeanFactory().createBean(formatterClass) : (Formatter)BeanUtils.instantiate(formatterClass);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConvertingFormatter
    implements Formatter {
        private final Class<?> type;
        private final Class<?> formattedObjectType;
        private final Formatter targetFormatter;

        public ConvertingFormatter(Class<?> type, Class<?> formattedObjectType, Formatter targetFormatter) {
            this.type = type;
            this.formattedObjectType = formattedObjectType;
            this.targetFormatter = targetFormatter;
        }

        public String format(Object object, Locale locale) {
            object = GenericFormatterRegistry.this.conversionService.convert(object, this.formattedObjectType);
            return this.targetFormatter.format(object, locale);
        }

        public Object parse(String formatted, Locale locale) throws ParseException {
            Object parsed = this.targetFormatter.parse(formatted, locale);
            parsed = GenericFormatterRegistry.this.conversionService.convert(parsed, this.type);
            return parsed;
        }
    }

    private static class SimpleAnnotationFormatterFactory
    implements AnnotationFormatterFactory {
        private final Formatter instance;

        public SimpleAnnotationFormatterFactory(Formatter instance) {
            this.instance = instance;
        }

        public Formatter getFormatter(Annotation annotation) {
            return this.instance;
        }
    }
}

