/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ui.format.support;

import java.beans.PropertyEditorSupport;
import java.text.ParseException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.ui.format.Formatter;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormattingPropertyEditorAdapter
extends PropertyEditorSupport {
    private final Formatter<Object> formatter;

    public FormattingPropertyEditorAdapter(Formatter<Object> formatter) {
        Assert.notNull(formatter, (String)"Formatter must not be null");
        this.formatter = formatter;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        try {
            this.setValue(this.formatter.parse(text, LocaleContextHolder.getLocale()));
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Failed to parse formatted value", ex);
        }
    }

    @Override
    public String getAsText() {
        return this.formatter.format(this.getValue(), LocaleContextHolder.getLocale());
    }
}

