/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ui.format.support;

import java.text.ParseException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.convert.support.GenericConverter;
import org.springframework.ui.format.Formatter;
import org.springframework.ui.format.FormatterRegistry;
import org.springframework.ui.format.support.GenericFormatterRegistry;
import org.springframework.util.Assert;

public class FormattingConversionServiceAdapter
extends GenericConversionService {
    private final FormatterRegistry formatterRegistry;

    public FormattingConversionServiceAdapter(FormatterRegistry formatterRegistry) {
        Assert.notNull((Object)formatterRegistry, (String)"FormatterRegistry must not be null");
        this.formatterRegistry = formatterRegistry;
        if (formatterRegistry instanceof GenericFormatterRegistry) {
            this.setParent(((GenericFormatterRegistry)formatterRegistry).getConversionService());
        } else {
            this.setParent((ConversionService)new DefaultConversionService());
        }
    }

    protected GenericConverter getConverter(TypeDescriptor sourceType, TypeDescriptor targetType) {
        Formatter<Object> formatter;
        if (String.class.equals((Object)sourceType.getType()) && (formatter = this.formatterRegistry.getFormatter(targetType)) != null) {
            return new FormattingConverter(formatter);
        }
        return super.getConverter(sourceType, targetType);
    }

    private static class FormattingConverter
    implements GenericConverter {
        private final Formatter formatter;

        public FormattingConverter(Formatter formatter) {
            this.formatter = formatter;
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            try {
                return this.formatter.parse((String)source, LocaleContextHolder.getLocale());
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("Could not convert formatted value '" + source + "'", ex);
            }
        }
    }
}

