/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ui.format.number;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.springframework.ui.format.number.AbstractNumberFormatter;

public final class DecimalFormatter
extends AbstractNumberFormatter {
    private String pattern;

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public NumberFormat getNumberFormat(Locale locale) {
        NumberFormat format = NumberFormat.getInstance(locale);
        if (!(format instanceof DecimalFormat)) {
            if (this.pattern != null) {
                throw new IllegalStateException("Cannot support pattern for non-DecimalFormat: " + format);
            }
            return format;
        }
        DecimalFormat decimalFormat = (DecimalFormat)format;
        decimalFormat.setParseBigDecimal(true);
        if (this.pattern != null) {
            decimalFormat.applyPattern(this.pattern);
        }
        return decimalFormat;
    }
}

