/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ui.format.number;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Currency;
import java.util.Locale;
import org.springframework.ui.format.number.AbstractNumberFormatter;
import org.springframework.util.ClassUtils;

public final class CurrencyFormatter
extends AbstractNumberFormatter {
    private static final boolean roundingModeOnDecimalFormat = ClassUtils.hasMethod(DecimalFormat.class, (String)"setRoundingMode", (Class[])new Class[]{RoundingMode.class});
    private int fractionDigits = 2;
    private RoundingMode roundingMode;
    private Currency currency;

    public void setFractionDigits(int fractionDigits) {
        this.fractionDigits = fractionDigits;
    }

    public void setRoundingMode(RoundingMode roundingMode) {
        this.roundingMode = roundingMode;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public BigDecimal parse(String formatted, Locale locale) throws ParseException {
        BigDecimal decimal = (BigDecimal)super.parse(formatted, locale);
        if (decimal != null) {
            decimal = this.roundingMode != null ? decimal.setScale(this.fractionDigits, this.roundingMode) : decimal.setScale(this.fractionDigits);
        }
        return decimal;
    }

    protected NumberFormat getNumberFormat(Locale locale) {
        DecimalFormat format = (DecimalFormat)NumberFormat.getCurrencyInstance(locale);
        format.setParseBigDecimal(true);
        format.setMaximumFractionDigits(this.fractionDigits);
        format.setMinimumFractionDigits(this.fractionDigits);
        if (this.roundingMode != null && roundingModeOnDecimalFormat) {
            format.setRoundingMode(this.roundingMode);
        }
        if (this.currency != null) {
            format.setCurrency(this.currency);
        }
        return format;
    }
}

