/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.support;

import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.springframework.util.StringUtils;

class CronSequenceGenerator {
    private final BitSet seconds = new BitSet(60);
    private final BitSet minutes = new BitSet(60);
    private final BitSet hours = new BitSet(24);
    private final BitSet daysOfWeek = new BitSet(7);
    private final BitSet daysOfMonth = new BitSet(31);
    private final BitSet months = new BitSet(12);
    private final String expression;

    public CronSequenceGenerator(String expression) {
        this.expression = expression;
        this.parse(expression);
    }

    public Date next(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(13, 1);
        calendar.set(14, 0);
        int second = calendar.get(13);
        this.findNext(this.seconds, second, 60, calendar, 13, new int[0]);
        int minute = calendar.get(12);
        this.findNext(this.minutes, minute, 60, calendar, 12, 13);
        int hour = calendar.get(11);
        this.findNext(this.hours, hour, 24, calendar, 11, 12, 13);
        int dayOfWeek = calendar.get(7);
        int dayOfMonth = calendar.get(5);
        this.findNextDay(calendar, this.daysOfMonth, dayOfMonth, this.daysOfWeek, dayOfWeek, 366);
        int month = calendar.get(2);
        this.findNext(this.months, month, 12, calendar, 2, 5, 11, 12, 13);
        return calendar.getTime();
    }

    private void findNextDay(Calendar calendar, BitSet daysOfMonth, int dayOfMonth, BitSet daysOfWeek, int dayOfWeek, int max) {
        int count = 0;
        while (!(daysOfMonth.get(dayOfMonth) && daysOfWeek.get(dayOfWeek - 1) || count++ >= max)) {
            calendar.add(5, 1);
            dayOfMonth = calendar.get(5);
            dayOfWeek = calendar.get(7);
            this.reset(calendar, 11, 12, 13);
        }
        if (count > max) {
            throw new IllegalStateException("Overflow in day for expression=" + this.expression);
        }
    }

    private void findNext(BitSet bits, int value, int max, Calendar calendar, int field, int ... lowerOrders) {
        int nextValue = bits.nextSetBit(value);
        if (nextValue == -1) {
            calendar.add(field, max - value);
            nextValue = bits.nextSetBit(0);
        }
        if (nextValue != value) {
            calendar.set(field, nextValue);
            this.reset(calendar, lowerOrders);
        }
    }

    private void reset(Calendar calendar, int ... fields) {
        int[] nArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            int field = nArray[n2];
            calendar.set(field, 0);
            ++n2;
        }
    }

    private void parse(String expression) throws IllegalArgumentException {
        String[] fields = StringUtils.tokenizeToStringArray((String)expression, (String)" ");
        if (fields.length != 6) {
            throw new IllegalArgumentException(String.format("cron expression must consist of 6 fields (found %d in %s)", fields.length, expression));
        }
        this.setNumberHits(this.seconds, fields[0], 60);
        this.setNumberHits(this.minutes, fields[1], 60);
        this.setNumberHits(this.hours, fields[2], 24);
        this.setDaysOfMonth(this.daysOfMonth, fields[3], 31);
        this.setNumberHits(this.months, this.replaceOrdinals(fields[4], "JAN,FEB,MAR,APR,MAY,JUN,JUL,AUG,SEP,OCT,NOV,DEC"), 12);
        this.setDays(this.daysOfWeek, this.replaceOrdinals(fields[5], "SUN,MON,TUE,WED,THU,FRI,SAT"), 8);
        if (this.daysOfWeek.get(7)) {
            this.daysOfWeek.set(0);
            this.daysOfWeek.clear(7);
        }
    }

    private String replaceOrdinals(String value, String commaSeparatedList) {
        String[] list = StringUtils.commaDelimitedListToStringArray((String)commaSeparatedList);
        int i = 0;
        while (i < list.length) {
            String item = list[i].toUpperCase();
            value = StringUtils.replace((String)value.toUpperCase(), (String)item, (String)("" + i));
            ++i;
        }
        return value;
    }

    private void setDaysOfMonth(BitSet bits, String field, int max) {
        this.setDays(bits, field, max + 1);
        bits.clear(0);
    }

    private void setDays(BitSet bits, String field, int max) {
        if (field.contains("?")) {
            field = "*";
        }
        this.setNumberHits(bits, field, max);
    }

    private void setNumberHits(BitSet bits, String value, int max) {
        String[] fields;
        String[] stringArray = fields = StringUtils.delimitedListToStringArray((String)value, (String)",");
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            if (!field.contains("/")) {
                int[] range = this.getRange(field, max);
                bits.set(range[0], range[1] + 1);
            } else {
                String[] split = StringUtils.delimitedListToStringArray((String)field, (String)"/");
                if (split.length > 2) {
                    throw new IllegalArgumentException("Incrementer has more than two fields: " + field);
                }
                int[] range = this.getRange(split[0], max);
                if (!split[0].contains("-")) {
                    range[1] = max - 1;
                }
                int delta = Integer.valueOf(split[1]);
                int i = range[0];
                while (i <= range[1]) {
                    bits.set(i);
                    i += delta;
                }
            }
            ++n2;
        }
    }

    private int[] getRange(String field, int max) {
        int[] result = new int[2];
        if (field.contains("*")) {
            result[0] = 0;
            result[1] = max - 1;
            return result;
        }
        if (!field.contains("-")) {
            result[0] = result[1] = Integer.valueOf(field).intValue();
        } else {
            String[] split = StringUtils.delimitedListToStringArray((String)field, (String)"-");
            if (split.length > 2) {
                throw new IllegalArgumentException("Range has more than two fields: " + field);
            }
            result[0] = Integer.valueOf(split[0]);
            result[1] = Integer.valueOf(split[1]);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CronSequenceGenerator)) {
            return false;
        }
        CronSequenceGenerator cron = (CronSequenceGenerator)obj;
        return cron.months.equals(this.months) && cron.daysOfMonth.equals(this.daysOfMonth) && cron.daysOfWeek.equals(this.daysOfWeek) && cron.hours.equals(this.hours) && cron.minutes.equals(this.minutes) && cron.seconds.equals(this.seconds);
    }

    public int hashCode() {
        return 37 + 17 * this.months.hashCode() + 29 * this.daysOfMonth.hashCode() + 37 * this.daysOfWeek.hashCode() + 41 * this.hours.hashCode() + 53 * this.minutes.hashCode() + 61 * this.seconds.hashCode();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + ": " + this.expression;
    }
}

