/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Stack;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationClass;
import org.springframework.context.annotation.ConfigurationClassMethod;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.Resource;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.StandardAnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigurationClassParser {
    private final MetadataReaderFactory metadataReaderFactory;
    private final ProblemReporter problemReporter;
    private final Set<ConfigurationClass> model;
    private final Stack<ConfigurationClass> importStack = new ImportStack();

    public ConfigurationClassParser(MetadataReaderFactory metadataReaderFactory, ProblemReporter problemReporter) {
        this.metadataReaderFactory = metadataReaderFactory;
        this.problemReporter = problemReporter;
        this.model = new LinkedHashSet<ConfigurationClass>();
    }

    public void parse(String className, String beanName) throws IOException {
        MetadataReader reader = this.metadataReaderFactory.getMetadataReader(className);
        this.processConfigurationClass(new ConfigurationClass(reader, beanName));
    }

    public void parse(Class clazz, String beanName) throws IOException {
        this.processConfigurationClass(new ConfigurationClass(clazz, beanName));
    }

    protected void processConfigurationClass(ConfigurationClass configClass) throws IOException {
        AnnotationMetadata metadata = configClass.getMetadata();
        while (metadata != null) {
            this.doProcessConfigurationClass(configClass, metadata);
            String superClassName = metadata.getSuperClassName();
            if (superClassName != null && !Object.class.getName().equals(superClassName)) {
                if (metadata instanceof StandardAnnotationMetadata) {
                    Class clazz = ((StandardAnnotationMetadata)metadata).getIntrospectedClass();
                    metadata = new StandardAnnotationMetadata(clazz.getSuperclass());
                    continue;
                }
                MetadataReader reader = this.metadataReaderFactory.getMetadataReader(superClassName);
                metadata = reader.getAnnotationMetadata();
                continue;
            }
            metadata = null;
        }
        if (this.model.contains(configClass) && configClass.getBeanName() != null) {
            this.model.remove(configClass);
        }
        this.model.add(configClass);
    }

    protected void doProcessConfigurationClass(ConfigurationClass configClass, AnnotationMetadata metadata) throws IOException {
        if (metadata.isAnnotated(Import.class.getName())) {
            this.processImport(configClass, (String[])metadata.getAnnotationAttributes(Import.class.getName()).get("value"));
        }
        Set methods = metadata.getAnnotatedMethods(Bean.class.getName());
        for (MethodMetadata methodMetadata : methods) {
            configClass.addMethod(new ConfigurationClassMethod(methodMetadata, configClass));
        }
    }

    public void processImport(ConfigurationClass configClass, String[] classesToImport) throws IOException {
        if (this.importStack.contains(configClass)) {
            this.problemReporter.error((Problem)new CircularImportProblem(configClass, this.importStack, configClass.getMetadata()));
        } else {
            this.importStack.push(configClass);
            String[] stringArray = classesToImport;
            int n = classesToImport.length;
            int n2 = 0;
            while (n2 < n) {
                String classToImport = stringArray[n2];
                this.processClassToImport(classToImport);
                ++n2;
            }
            this.importStack.pop();
        }
    }

    private void processClassToImport(String classToImport) throws IOException {
        MetadataReader reader = this.metadataReaderFactory.getMetadataReader(classToImport);
        AnnotationMetadata metadata = reader.getAnnotationMetadata();
        if (!metadata.isAnnotated(Configuration.class.getName())) {
            this.problemReporter.error((Problem)new NonAnnotatedConfigurationProblem(metadata.getClassName(), reader.getResource(), metadata));
        } else {
            this.processConfigurationClass(new ConfigurationClass(reader, null));
        }
    }

    public void validate() {
        for (ConfigurationClass configClass : this.model) {
            configClass.validate(this.problemReporter);
        }
    }

    public Set<ConfigurationClass> getModel() {
        return this.model;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CircularImportProblem
    extends Problem {
        public CircularImportProblem(ConfigurationClass attemptedImport, Stack<ConfigurationClass> importStack, AnnotationMetadata metadata) {
            super(String.format("A circular @Import has been detected: Illegal attempt by @Configuration class '%s' to import class '%s' as '%s' is already present in the current import stack [%s]", importStack.peek().getSimpleName(), attemptedImport.getSimpleName(), attemptedImport.getSimpleName(), importStack), new Location(importStack.peek().getResource(), (Object)metadata));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImportStack
    extends Stack<ConfigurationClass> {
        private ImportStack() {
        }

        @Override
        public boolean contains(Object elem) {
            ConfigurationClass configClass = (ConfigurationClass)elem;
            Comparator<ConfigurationClass> comparator = new Comparator<ConfigurationClass>(){

                @Override
                public int compare(ConfigurationClass first, ConfigurationClass second) {
                    return first.getMetadata().getClassName().equals(second.getMetadata().getClassName()) ? 0 : 1;
                }
            };
            return Collections.binarySearch(this, configClass, comparator) != -1;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                builder.append(((ConfigurationClass)iterator.next()).getSimpleName());
                if (!iterator.hasNext()) continue;
                builder.append("->");
            }
            return builder.toString();
        }
    }

    private static class NonAnnotatedConfigurationProblem
    extends Problem {
        public NonAnnotatedConfigurationProblem(String className, Resource resource, AnnotationMetadata metadata) {
            super(String.format("%s was imported as a @Configuration class but was not actually annotated with @Configuration. Annotate the class or do not attempt to process it.", className), new Location(resource, (Object)metadata));
        }
    }
}

