/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading;

import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShadowingClassLoader
extends ClassLoader {
    private final ClassLoader enclosingClassLoader;
    private final List<ClassFileTransformer> classFileTransformers = new ArrayList<ClassFileTransformer>();
    private final Map<String, Class> classCache = new HashMap<String, Class>();

    public ShadowingClassLoader(ClassLoader enclosingClassLoader) {
        Assert.notNull((Object)enclosingClassLoader, (String)"Enclosing ClassLoader must not be null");
        this.enclosingClassLoader = enclosingClassLoader;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.shouldShadow(name)) {
            Class cls = this.classCache.get(name);
            if (cls != null) {
                return cls;
            }
            return this.doLoadClass(name);
        }
        return this.enclosingClassLoader.loadClass(name);
    }

    private boolean shouldShadow(String name) {
        return !this.isExcluded(name);
    }

    private boolean isExcluded(String name) {
        return name.equals(this.getClass().getName()) || name.endsWith("ShadowingClassLoader") || name.startsWith("org.dom4j") || name.startsWith("org.aspectj") || name.startsWith("org.apache.xerces") || name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("org.apache.commons.logging") || name.startsWith("org.xml.sax") || name.startsWith("org.w3c") || name.startsWith("sun") || this.isClassNameExcludedFromShadowing(name);
    }

    protected boolean isClassNameExcludedFromShadowing(String className) {
        return false;
    }

    private Class doLoadClass(String name) throws ClassNotFoundException {
        String internalName = StringUtils.replace((String)name, (String)".", (String)"/") + ".class";
        InputStream is = this.getParent().getResourceAsStream(internalName);
        if (is == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            byte[] bytes = FileCopyUtils.copyToByteArray((InputStream)is);
            bytes = this.applyTransformers(name, bytes);
            Class<?> cls = this.defineClass(name, bytes, 0, bytes.length);
            this.classCache.put(name, cls);
            return cls;
        }
        catch (IOException ex) {
            throw new ClassNotFoundException("Cannot load resource for class [" + name + "]", ex);
        }
    }

    public void addTransformers(ShadowingClassLoader other) {
        this.classFileTransformers.addAll(other.classFileTransformers);
    }

    private byte[] applyTransformers(String name, byte[] bytes) {
        String internalName = StringUtils.replace((String)name, (String)".", (String)"/");
        try {
            for (ClassFileTransformer transformer : this.classFileTransformers) {
                byte[] transformed = transformer.transform(this, internalName, null, null, bytes);
                bytes = transformed != null ? transformed : bytes;
            }
            return bytes;
        }
        catch (IllegalClassFormatException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void addTransformer(ClassFileTransformer transformer) {
        this.classFileTransformers.add(transformer);
    }
}

