/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.quartz;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.quartz.spi.ClassLoadHelper;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ResourceLoaderClassLoadHelper
implements ClassLoadHelper {
    protected static final Log logger = LogFactory.getLog(ResourceLoaderClassLoadHelper.class);
    private @Nullable ResourceLoader resourceLoader;

    public ResourceLoaderClassLoadHelper() {
    }

    public ResourceLoaderClassLoadHelper(@Nullable ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void initialize() {
        if (this.resourceLoader == null) {
            this.resourceLoader = SchedulerFactoryBean.getConfigTimeResourceLoader();
            if (this.resourceLoader == null) {
                this.resourceLoader = new DefaultResourceLoader();
            }
        }
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Assert.state((this.resourceLoader != null ? 1 : 0) != 0, (String)"ResourceLoaderClassLoadHelper not initialized");
        return ClassUtils.forName((String)name, (ClassLoader)this.resourceLoader.getClassLoader());
    }

    public <T> Class<? extends T> loadClass(String name, Class<T> clazz) throws ClassNotFoundException {
        return this.loadClass(name);
    }

    public @Nullable URL getResource(String name) {
        Assert.state((this.resourceLoader != null ? 1 : 0) != 0, (String)"ResourceLoaderClassLoadHelper not initialized");
        Resource resource = this.resourceLoader.getResource(name);
        if (resource.exists()) {
            try {
                return resource.getURL();
            }
            catch (IOException ex) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Could not load " + String.valueOf(resource)));
                }
                return null;
            }
        }
        return this.getClassLoader().getResource(name);
    }

    public @Nullable InputStream getResourceAsStream(String name) {
        Assert.state((this.resourceLoader != null ? 1 : 0) != 0, (String)"ResourceLoaderClassLoadHelper not initialized");
        Resource resource = this.resourceLoader.getResource(name);
        if (resource.exists()) {
            try {
                return resource.getInputStream();
            }
            catch (IOException ex) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Could not load " + String.valueOf(resource)));
                }
                return null;
            }
        }
        return this.getClassLoader().getResourceAsStream(name);
    }

    public ClassLoader getClassLoader() {
        Assert.state((this.resourceLoader != null ? 1 : 0) != 0, (String)"ResourceLoaderClassLoadHelper not initialized");
        ClassLoader classLoader = this.resourceLoader.getClassLoader();
        Assert.state((classLoader != null ? 1 : 0) != 0, (String)"No ClassLoader");
        return classLoader;
    }
}

