/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.index.processor;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

class TypeHelper {
    private final ProcessingEnvironment env;
    private final Types types;

    public TypeHelper(ProcessingEnvironment env) {
        this.env = env;
        this.types = env.getTypeUtils();
    }

    public String getType(Element element) {
        return this.getType(element != null ? element.asType() : null);
    }

    public String getType(AnnotationMirror annotation) {
        return this.getType(annotation != null ? annotation.getAnnotationType() : null);
    }

    public String getType(TypeMirror type) {
        if (type == null) {
            return null;
        }
        if (type instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)type;
            Element enclosingElement = declaredType.asElement().getEnclosingElement();
            if (enclosingElement != null && enclosingElement instanceof TypeElement) {
                return this.getQualifiedName(enclosingElement) + "$" + declaredType.asElement().getSimpleName().toString();
            }
            return this.getQualifiedName(declaredType.asElement());
        }
        return type.toString();
    }

    private String getQualifiedName(Element element) {
        if (element instanceof QualifiedNameable) {
            return ((QualifiedNameable)element).getQualifiedName().toString();
        }
        return element.toString();
    }

    public Element getSuperClass(Element element) {
        List<? extends TypeMirror> superTypes = this.types.directSupertypes(element.asType());
        if (superTypes.isEmpty()) {
            return null;
        }
        return this.types.asElement(superTypes.get(0));
    }

    public List<Element> getDirectInterfaces(Element element) {
        List<? extends TypeMirror> superTypes = this.types.directSupertypes(element.asType());
        ArrayList<Element> directInterfaces = new ArrayList<Element>();
        if (superTypes.size() > 1) {
            for (int i = 1; i < superTypes.size(); ++i) {
                Element e = this.types.asElement(superTypes.get(i));
                if (e == null) continue;
                directInterfaces.add(e);
            }
        }
        return directInterfaces;
    }

    public List<? extends AnnotationMirror> getAllAnnotationMirrors(Element e) {
        return this.env.getElementUtils().getAllAnnotationMirrors(e);
    }
}

