/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.xml;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.ReaderContext;
import org.springframework.beans.factory.xml.BeanDefinitionDocumentReader;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.util.SystemPropertyUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultBeanDefinitionDocumentReader
implements BeanDefinitionDocumentReader {
    public static final String BEANS_NAMESPACE_URI = "http://www.springframework.org/schema/beans";
    public static final String BEAN_NAME_DELIMITERS = ",; ";
    public static final String IMPORT_ELEMENT = "import";
    public static final String RESOURCE_ATTRIBUTE = "resource";
    public static final String ALIAS_ELEMENT = "alias";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String ALIAS_ATTRIBUTE = "alias";
    public static final String BEAN_ELEMENT = "bean";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private XmlReaderContext readerContext;

    public void registerBeanDefinitions(Document doc, XmlReaderContext readerContext) {
        this.readerContext = readerContext;
        this.logger.debug((Object)"Loading bean definitions");
        Element root = doc.getDocumentElement();
        BeanDefinitionParserDelegate delegate = this.createHelper(readerContext, root);
        this.preProcessXml(root);
        this.parseBeanDefinitions(root, delegate);
        this.postProcessXml(root);
    }

    protected BeanDefinitionParserDelegate createHelper(XmlReaderContext readerContext, Element root) {
        BeanDefinitionParserDelegate delegate = new BeanDefinitionParserDelegate(readerContext);
        delegate.initDefaults(root);
        return delegate;
    }

    protected final ReaderContext getReaderContext() {
        return this.readerContext;
    }

    protected void preProcessXml(Element root) {
    }

    protected void parseBeanDefinitions(Element root, BeanDefinitionParserDelegate delegate) {
        if (delegate.isDefaultNamespace(root.getNamespaceURI())) {
            NodeList nl = root.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                if (!(node instanceof Element)) continue;
                Element ele = (Element)node;
                String namespaceUri = ele.getNamespaceURI();
                if (delegate.isDefaultNamespace(namespaceUri)) {
                    this.parseDefaultElement(ele, delegate);
                    continue;
                }
                delegate.parseCustomElement(ele, false);
            }
        } else {
            delegate.parseCustomElement(root, false);
        }
    }

    private void parseDefaultElement(Element ele, BeanDefinitionParserDelegate delegate) {
        BeanDefinitionHolder bdHolder;
        if (DomUtils.nodeNameEquals((Node)ele, (String)IMPORT_ELEMENT)) {
            this.importBeanDefinitionResource(ele);
        } else if (DomUtils.nodeNameEquals((Node)ele, (String)"alias")) {
            String name = ele.getAttribute(NAME_ATTRIBUTE);
            String alias = ele.getAttribute("alias");
            this.getReaderContext().getReader().getBeanFactory().registerAlias(name, alias);
            Object source = this.getReaderContext().getSourceExtractor().extract(ele);
            this.getReaderContext().fireAliasRegistered(name, alias, source);
        } else if (DomUtils.nodeNameEquals((Node)ele, (String)BEAN_ELEMENT) && (bdHolder = delegate.parseBeanDefinitionElement(ele, false)) != null) {
            bdHolder = delegate.decorateBeanDefinitionIfRequired(ele, bdHolder);
            BeanDefinitionReaderUtils.registerBeanDefinition(bdHolder, this.getReaderContext().getReader().getBeanFactory());
            this.getReaderContext().fireComponentRegistered(new BeanComponentDefinition(bdHolder));
        }
    }

    protected void importBeanDefinitionResource(Element ele) {
        String location = ele.getAttribute(RESOURCE_ATTRIBUTE);
        if (ResourcePatternUtils.isUrl((String)(location = SystemPropertyUtils.resolvePlaceholders((String)location)))) {
            int importCount = this.getReaderContext().getReader().loadBeanDefinitions(location);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Imported " + importCount + " bean definitions from URL location [" + location + "]"));
            }
        } else {
            try {
                Resource relativeResource = this.getReaderContext().getResource().createRelative(location);
                int importCount = this.getReaderContext().getReader().loadBeanDefinitions(relativeResource);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Imported " + importCount + " bean definitions from relative location [" + location + "]"));
                }
            }
            catch (IOException ex) {
                this.getReaderContext().error("Invalid relative resource location [" + location + "] to import bean definitions from", ele, null, ex);
            }
        }
        Object source = this.getReaderContext().getSourceExtractor().extract(ele);
        this.getReaderContext().fireImportProcessed(location, source);
    }

    protected void postProcessXml(Element root) {
    }
}

