/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.Mergeable;
import org.springframework.util.Assert;

public class ManagedList
extends ArrayList
implements Mergeable {
    private boolean mergeEnabled;
    private Object source;

    public ManagedList() {
    }

    public ManagedList(int initialCapacity) {
        super(initialCapacity);
    }

    public void setMergeEnabled(boolean mergeEnabled) {
        this.mergeEnabled = mergeEnabled;
    }

    public boolean isMergeEnabled() {
        return this.mergeEnabled;
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public synchronized Object merge(Object parent) {
        if (!this.mergeEnabled) {
            throw new IllegalStateException("Cannot merge when the mergeEnabled property is false.");
        }
        Assert.notNull((Object)parent);
        if (parent instanceof List) {
            ArrayList temp = new ArrayList((List)parent);
            temp.addAll(this);
            return temp;
        }
        throw new IllegalArgumentException("Cannot merge object with object of type [" + parent.getClass() + "]");
    }
}

