/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.weaver.tools.ShadowMatch;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.support.ExpressionPointcut;

public abstract class ShadowMatchUtils {
    private static final Map<Key, ShadowMatch> shadowMatchCache = new ConcurrentHashMap<Key, ShadowMatch>(256);

    public static void clearCache() {
        shadowMatchCache.clear();
    }

    static @Nullable ShadowMatch getShadowMatch(ExpressionPointcut expression, Method method) {
        return shadowMatchCache.get(new Key(expression, method));
    }

    static ShadowMatch setShadowMatch(ExpressionPointcut expression, Method method, ShadowMatch shadowMatch) {
        ShadowMatch existing = shadowMatchCache.putIfAbsent(new Key(expression, method), shadowMatch);
        return existing != null ? existing : shadowMatch;
    }

    private record Key(ExpressionPointcut expression, Method method) {
    }
}

