/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.scope;

import java.lang.reflect.Executable;
import java.lang.reflect.Type;
import java.util.function.Predicate;
import javax.lang.model.element.Modifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.scope.ScopedProxyFactoryBean;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.aot.BeanRegistrationCodeFragments;
import org.springframework.beans.factory.aot.BeanRegistrationCodeFragmentsCustomizer;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.InstanceSupplier;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.ResolvableType;
import org.springframework.javapoet.CodeBlock;
import org.springframework.lang.Nullable;

class ScopedProxyBeanRegistrationCodeFragmentsCustomizer
implements BeanRegistrationCodeFragmentsCustomizer {
    private static final Log logger = LogFactory.getLog(ScopedProxyBeanRegistrationCodeFragmentsCustomizer.class);

    ScopedProxyBeanRegistrationCodeFragmentsCustomizer() {
    }

    public BeanRegistrationCodeFragments customizeBeanRegistrationCodeFragments(RegisteredBean registeredBean, BeanRegistrationCodeFragments codeFragments) {
        Class beanType = registeredBean.getBeanType().toClass();
        if (!beanType.equals(ScopedProxyFactoryBean.class)) {
            return codeFragments;
        }
        String targetBeanName = this.getTargetBeanName((BeanDefinition)registeredBean.getMergedBeanDefinition());
        BeanDefinition targetBeanDefinition = this.getTargetBeanDefinition(registeredBean.getBeanFactory(), targetBeanName);
        if (targetBeanDefinition == null) {
            logger.warn((Object)("Could not handle " + ScopedProxyFactoryBean.class.getSimpleName() + ": no target bean definition found with name " + targetBeanName));
            return codeFragments;
        }
        return new ScopedProxyBeanRegistrationCodeFragments(codeFragments, registeredBean, targetBeanName, targetBeanDefinition);
    }

    @Nullable
    private String getTargetBeanName(BeanDefinition beanDefinition) {
        Object value = beanDefinition.getPropertyValues().get("targetBeanName");
        return value instanceof String ? (String)value : null;
    }

    @Nullable
    private BeanDefinition getTargetBeanDefinition(ConfigurableBeanFactory beanFactory, @Nullable String targetBeanName) {
        if (targetBeanName != null && beanFactory.containsBean(targetBeanName)) {
            return beanFactory.getMergedBeanDefinition(targetBeanName);
        }
        return null;
    }

    private static class ScopedProxyBeanRegistrationCodeFragments
    extends BeanRegistrationCodeFragments {
        private static final String REGISTERED_BEAN_PARAMETER_NAME = "registeredBean";
        private final RegisteredBean registeredBean;
        private final String targetBeanName;
        private final BeanDefinition targetBeanDefinition;

        ScopedProxyBeanRegistrationCodeFragments(BeanRegistrationCodeFragments codeGenerator, RegisteredBean registeredBean, String targetBeanName, BeanDefinition targetBeanDefinition) {
            super(codeGenerator);
            this.registeredBean = registeredBean;
            this.targetBeanName = targetBeanName;
            this.targetBeanDefinition = targetBeanDefinition;
        }

        public Class<?> getTarget(RegisteredBean registeredBean, Executable constructorOrFactoryMethod) {
            return this.targetBeanDefinition.getResolvableType().toClass();
        }

        public CodeBlock generateNewBeanDefinitionCode(GenerationContext generationContext, ResolvableType beanType, BeanRegistrationCode beanRegistrationCode) {
            return super.generateNewBeanDefinitionCode(generationContext, this.targetBeanDefinition.getResolvableType(), beanRegistrationCode);
        }

        public CodeBlock generateSetBeanDefinitionPropertiesCode(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode, RootBeanDefinition beanDefinition, Predicate<String> attributeFilter) {
            RootBeanDefinition processedBeanDefinition = new RootBeanDefinition(beanDefinition);
            processedBeanDefinition.setTargetType(this.targetBeanDefinition.getResolvableType());
            processedBeanDefinition.getPropertyValues().removePropertyValue("targetBeanName");
            return super.generateSetBeanDefinitionPropertiesCode(generationContext, beanRegistrationCode, processedBeanDefinition, attributeFilter);
        }

        public CodeBlock generateInstanceSupplierCode(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode, Executable constructorOrFactoryMethod, boolean allowDirectSupplierShortcut) {
            GeneratedMethod method = beanRegistrationCode.getMethodGenerator().generateMethod(new Object[]{"get", "scopedProxyInstance"}).using(builder -> {
                Class beanClass = this.targetBeanDefinition.getResolvableType().toClass();
                builder.addJavadoc("Create the scoped proxy bean instance for '$L'.", new Object[]{this.registeredBean.getBeanName()});
                builder.addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC});
                builder.returns((Type)beanClass);
                builder.addParameter(RegisteredBean.class, REGISTERED_BEAN_PARAMETER_NAME, new Modifier[0]);
                builder.addStatement("$T factory = new $T()", new Object[]{ScopedProxyFactoryBean.class, ScopedProxyFactoryBean.class});
                builder.addStatement("factory.setTargetBeanName($S)", new Object[]{this.targetBeanName});
                builder.addStatement("factory.setBeanFactory($L.getBeanFactory())", new Object[]{REGISTERED_BEAN_PARAMETER_NAME});
                builder.addStatement("return ($T) factory.getObject()", new Object[]{beanClass});
            });
            return CodeBlock.of((String)"$T.of($T::$L)", (Object[])new Object[]{InstanceSupplier.class, beanRegistrationCode.getClassName(), method.getName()});
        }
    }
}

