/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;

public class AspectJWeaverMessageHandler
implements IMessageHandler {
    private static final String AJ_ID = "[AspectJ] ";
    private static final Log LOGGER = LogFactory.getLog((String)"AspectJ Weaver");

    public boolean handleMessage(IMessage message) throws AbortException {
        IMessage.Kind messageKind = message.getKind();
        if (messageKind == IMessage.DEBUG) {
            if (LOGGER.isDebugEnabled() || LOGGER.isTraceEnabled()) {
                LOGGER.debug((Object)this.makeMessageFor(message));
                return true;
            }
        } else if (messageKind == IMessage.INFO || messageKind == IMessage.WEAVEINFO) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)this.makeMessageFor(message));
                return true;
            }
        } else if (messageKind == IMessage.WARNING) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn((Object)this.makeMessageFor(message));
                return true;
            }
        } else if (messageKind == IMessage.ERROR) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error((Object)this.makeMessageFor(message));
                return true;
            }
        } else if (messageKind == IMessage.ABORT && LOGGER.isFatalEnabled()) {
            LOGGER.fatal((Object)this.makeMessageFor(message));
            return true;
        }
        return false;
    }

    private String makeMessageFor(IMessage aMessage) {
        return AJ_ID + aMessage.getMessage();
    }

    public boolean isIgnoring(IMessage.Kind messageKind) {
        return false;
    }

    public void dontIgnore(IMessage.Kind messageKind) {
    }

    public void ignore(IMessage.Kind kind) {
    }
}

