/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.framework;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.AopContext;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.aop.support.AopUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

final class JdkDynamicAopProxy
implements AopProxy,
InvocationHandler,
Serializable {
    private static final long serialVersionUID = 5531744639992436476L;
    private static Log logger = LogFactory.getLog((Class)(class$org$springframework$aop$framework$JdkDynamicAopProxy == null ? (class$org$springframework$aop$framework$JdkDynamicAopProxy = JdkDynamicAopProxy.class$("org.springframework.aop.framework.JdkDynamicAopProxy")) : class$org$springframework$aop$framework$JdkDynamicAopProxy));
    private final AdvisedSupport advised;
    private boolean equalsDefined;
    private boolean hashCodeDefined;
    static /* synthetic */ Class class$org$springframework$aop$framework$JdkDynamicAopProxy;
    static /* synthetic */ Class class$org$springframework$aop$framework$Advised;
    static /* synthetic */ Class class$org$springframework$aop$RawTargetAccess;

    public JdkDynamicAopProxy(AdvisedSupport config) throws AopConfigException {
        Assert.notNull((Object)config, (String)"AdvisedSupport must not be null");
        if (config.getAdvisors().length == 0 && config.getTargetSource() == AdvisedSupport.EMPTY_TARGET_SOURCE) {
            throw new AopConfigException("No advisors and no TargetSource specified");
        }
        this.advised = config;
    }

    public Object getProxy() {
        return this.getProxy(ClassUtils.getDefaultClassLoader());
    }

    public Object getProxy(ClassLoader classLoader) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating JDK dynamic proxy: target source is " + this.advised.getTargetSource()));
        }
        Class[] proxiedInterfaces = AopProxyUtils.completeProxiedInterfaces(this.advised);
        this.findDefinedEqualsAndHashCodeMethods(proxiedInterfaces);
        return Proxy.newProxyInstance(classLoader, proxiedInterfaces, (InvocationHandler)this);
    }

    private void findDefinedEqualsAndHashCodeMethods(Class[] proxiedInterfaces) {
        for (int i = 0; i < proxiedInterfaces.length; ++i) {
            Class proxiedInterface = proxiedInterfaces[i];
            Method[] methods = proxiedInterface.getDeclaredMethods();
            for (int j = 0; j < methods.length; ++j) {
                Method method = methods[j];
                if (AopUtils.isEqualsMethod(method)) {
                    this.equalsDefined = true;
                }
                if (AopUtils.isHashCodeMethod(method)) {
                    this.hashCodeDefined = true;
                }
                if (!this.equalsDefined || !this.hashCodeDefined) continue;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object object;
        boolean setProxyContext;
        Object oldProxy;
        block22: {
            List chain;
            Object target;
            Class<?> targetClass;
            TargetSource targetSource;
            ReflectiveMethodInvocation invocation;
            block20: {
                Object object2;
                block21: {
                    block18: {
                        Integer n;
                        block19: {
                            block16: {
                                Boolean bl;
                                block17: {
                                    invocation = null;
                                    oldProxy = null;
                                    setProxyContext = false;
                                    targetSource = this.advised.targetSource;
                                    targetClass = null;
                                    target = null;
                                    try {
                                        if (this.equalsDefined || !AopUtils.isEqualsMethod(method)) break block16;
                                        Boolean bl2 = bl = this.equals(args[0]) ? Boolean.TRUE : Boolean.FALSE;
                                        if (target == null || targetSource.isStatic()) break block17;
                                    }
                                    catch (Throwable throwable) {
                                        if (target != null && !targetSource.isStatic()) {
                                            targetSource.releaseTarget(target);
                                        }
                                        if (setProxyContext) {
                                            AopContext.setCurrentProxy(oldProxy);
                                        }
                                        throw throwable;
                                    }
                                    targetSource.releaseTarget(target);
                                }
                                if (setProxyContext) {
                                    AopContext.setCurrentProxy(oldProxy);
                                }
                                return bl;
                            }
                            if (this.hashCodeDefined || !AopUtils.isHashCodeMethod(method)) break block18;
                            n = new Integer(this.hashCode());
                            if (target == null || targetSource.isStatic()) break block19;
                            targetSource.releaseTarget(target);
                        }
                        if (setProxyContext) {
                            AopContext.setCurrentProxy(oldProxy);
                        }
                        return n;
                    }
                    if (this.advised.opaque || !method.getDeclaringClass().isInterface() || !method.getDeclaringClass().isAssignableFrom(class$org$springframework$aop$framework$Advised == null ? (class$org$springframework$aop$framework$Advised = JdkDynamicAopProxy.class$("org.springframework.aop.framework.Advised")) : class$org$springframework$aop$framework$Advised)) break block20;
                    object2 = AopUtils.invokeJoinpointUsingReflection(this.advised, method, args);
                    if (target == null || targetSource.isStatic()) break block21;
                    targetSource.releaseTarget(target);
                }
                if (setProxyContext) {
                    AopContext.setCurrentProxy(oldProxy);
                }
                return object2;
            }
            Object retVal = null;
            if (this.advised.exposeProxy) {
                oldProxy = AopContext.setCurrentProxy(proxy);
                setProxyContext = true;
            }
            if ((target = targetSource.getTarget()) != null) {
                targetClass = target.getClass();
            }
            if ((chain = this.advised.getInterceptorsAndDynamicInterceptionAdvice(method, targetClass)).isEmpty()) {
                retVal = AopUtils.invokeJoinpointUsingReflection(target, method, args);
            } else {
                invocation = new ReflectiveMethodInvocation(proxy, target, method, args, targetClass, chain);
                retVal = invocation.proceed();
            }
            if (retVal != null && retVal == target && method.getReturnType().isInstance(proxy) && !(class$org$springframework$aop$RawTargetAccess == null ? (class$org$springframework$aop$RawTargetAccess = JdkDynamicAopProxy.class$("org.springframework.aop.RawTargetAccess")) : class$org$springframework$aop$RawTargetAccess).isAssignableFrom(method.getDeclaringClass())) {
                retVal = proxy;
            }
            object = retVal;
            if (target == null || targetSource.isStatic()) break block22;
            targetSource.releaseTarget(target);
        }
        if (setProxyContext) {
            AopContext.setCurrentProxy(oldProxy);
        }
        return object;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        JdkDynamicAopProxy otherProxy = null;
        if (other instanceof JdkDynamicAopProxy) {
            otherProxy = (JdkDynamicAopProxy)other;
        } else if (Proxy.isProxyClass(other.getClass())) {
            InvocationHandler ih = Proxy.getInvocationHandler(other);
            if (!(ih instanceof JdkDynamicAopProxy)) {
                return false;
            }
            otherProxy = (JdkDynamicAopProxy)ih;
        } else {
            return false;
        }
        return AopProxyUtils.equalsInProxy(this.advised, otherProxy.advised);
    }

    public int hashCode() {
        return (class$org$springframework$aop$framework$JdkDynamicAopProxy == null ? (class$org$springframework$aop$framework$JdkDynamicAopProxy = JdkDynamicAopProxy.class$("org.springframework.aop.framework.JdkDynamicAopProxy")) : class$org$springframework$aop$framework$JdkDynamicAopProxy).hashCode() * 13 + this.advised.getTargetSource().hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

