/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractComponentDefinition;
import org.springframework.util.Assert;

public class PointcutComponentDefinition
extends AbstractComponentDefinition {
    private final String beanName;
    private final BeanDefinition pointcutDefinition;
    private final String description;
    private final String expression;

    public PointcutComponentDefinition(String beanName, BeanDefinition pointcutDefinition, String expression) {
        Assert.notNull((Object)beanName, (String)"'beanName' cannot be null.");
        Assert.notNull((Object)pointcutDefinition, (String)"'pointcutDefinition' cannot be null.");
        Assert.notNull((Object)expression, (String)"'expression' cannot be null.");
        this.beanName = beanName;
        this.pointcutDefinition = pointcutDefinition;
        this.expression = expression;
        this.description = "Pointcut <name='" + this.getName() + "', expression='" + this.expression + ">'";
    }

    public String getName() {
        return this.beanName;
    }

    public String getDescription() {
        return this.description;
    }

    public BeanDefinition[] getBeanDefinitions() {
        return new BeanDefinition[]{this.pointcutDefinition};
    }

    public Object getSource() {
        return this.pointcutDefinition.getSource();
    }
}

