/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj.annotation;

import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.AjType;
import org.aspectj.lang.reflect.AjTypeSystem;
import org.aspectj.lang.reflect.PerClauseKind;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.support.TypePatternClassFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectMetadata {
    private final AjType ajType;
    private final Pointcut perClausePointcut;
    private String aspectName;

    public AspectMetadata(Class<?> aspectClass, String aspectName) {
        this.aspectName = aspectName;
        this.ajType = AjTypeSystem.getAjType(aspectClass);
        if (!this.ajType.isAspect()) {
            throw new IllegalArgumentException("Class '" + aspectClass.getName() + "' is not an @AspectJ aspect");
        }
        this.validate();
        switch (this.ajType.getPerClause().getKind()) {
            case SINGLETON: {
                this.perClausePointcut = Pointcut.TRUE;
                return;
            }
            case PERTARGET: 
            case PERTHIS: {
                AspectJExpressionPointcut ajexp = new AspectJExpressionPointcut();
                ajexp.setLocation("@Aspect annotation on " + aspectClass.getName());
                ajexp.setExpression(this.findPerClause(aspectClass));
                this.perClausePointcut = ajexp;
                return;
            }
            case PERTYPEWITHIN: {
                final TypePatternClassFilter typePatternClassFilter = new TypePatternClassFilter(this.findPerClause(aspectClass));
                this.perClausePointcut = new Pointcut(){

                    public ClassFilter getClassFilter() {
                        return typePatternClassFilter;
                    }

                    public MethodMatcher getMethodMatcher() {
                        return MethodMatcher.TRUE;
                    }
                };
                return;
            }
        }
        throw new AopConfigException("PerClause " + this.ajType.getPerClause().getKind() + " not supported by Spring AOP for class " + aspectClass.getName());
    }

    private void validate() throws IllegalArgumentException {
        if (this.ajType.getDeclarePrecedence().length > 0) {
            throw new IllegalArgumentException("DeclarePrecendence not presently supported in Spring AOP");
        }
    }

    public boolean isPerThisOrPerTarget() {
        PerClauseKind kind = this.getAjType().getPerClause().getKind();
        return kind == PerClauseKind.PERTARGET || kind == PerClauseKind.PERTHIS;
    }

    public boolean isPerTypeWithin() {
        PerClauseKind kind = this.getAjType().getPerClause().getKind();
        return kind == PerClauseKind.PERTYPEWITHIN;
    }

    public boolean isLazilyInstantiated() {
        return this.isPerThisOrPerTarget() || this.isPerTypeWithin();
    }

    private String findPerClause(Class<?> aspectClass) {
        String s = aspectClass.getAnnotation(Aspect.class).value();
        s = s.substring(s.indexOf("(") + 1);
        s = s.substring(0, s.length() - 1);
        return s;
    }

    public AjType getAjType() {
        return this.ajType;
    }

    public Class<?> getAspectClass() {
        return this.ajType.getJavaClass();
    }

    public String getAspectName() {
        return this.aspectName;
    }

    public Pointcut getPerClausePointcut() {
        return this.perClausePointcut;
    }
}

