/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.config;

import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractComponentDefinition;
import org.springframework.util.Assert;

public class AdvisorComponentDefinition
extends AbstractComponentDefinition {
    private final String advisorBeanName;
    private final BeanDefinition advisorDefinition;
    private final BeanDefinition pointcutDefinition;
    private String description;
    private RuntimeBeanReference[] beanReferences;
    private BeanDefinition[] beanDefinitions;

    public AdvisorComponentDefinition(String advisorBeanName, BeanDefinition advisorDefinition) {
        this(advisorBeanName, advisorDefinition, null);
    }

    public AdvisorComponentDefinition(String advisorBeanName, BeanDefinition advisorDefinition, BeanDefinition pointcutDefinition) {
        Assert.notNull((Object)advisorBeanName, (String)"Advsor bean name must not be null");
        Assert.notNull((Object)advisorDefinition, (String)"Advisor definition must not be null");
        this.advisorBeanName = advisorBeanName;
        this.advisorDefinition = advisorDefinition;
        this.pointcutDefinition = pointcutDefinition;
        this.unwrapDefinitions(advisorDefinition, pointcutDefinition);
    }

    private void unwrapDefinitions(BeanDefinition advisorDefinition, BeanDefinition pointcutDefinition) {
        MutablePropertyValues propertyValues = advisorDefinition.getPropertyValues();
        RuntimeBeanReference adviceReference = (RuntimeBeanReference)propertyValues.getPropertyValue("advice").getValue();
        if (pointcutDefinition == null) {
            RuntimeBeanReference pointcutReference = (RuntimeBeanReference)propertyValues.getPropertyValue("pointcut").getValue();
            this.beanReferences = new RuntimeBeanReference[]{adviceReference, pointcutReference};
            this.beanDefinitions = new BeanDefinition[]{this.advisorDefinition};
            this.description = this.createDescription(adviceReference, pointcutReference);
        } else {
            this.beanReferences = new RuntimeBeanReference[]{adviceReference};
            this.beanDefinitions = new BeanDefinition[]{this.advisorDefinition, pointcutDefinition};
            this.description = this.createDescription(adviceReference, pointcutDefinition);
        }
    }

    private String createDescription(RuntimeBeanReference adviceReference, BeanDefinition pointcutDefinition) {
        return "Advisor <advice(ref)='" + adviceReference.getBeanName() + "', pointcut(expression)='" + pointcutDefinition.getPropertyValues().getPropertyValue("expression").getValue() + "'>";
    }

    private String createDescription(RuntimeBeanReference adviceReference, RuntimeBeanReference pointcutReference) {
        return "Advisor <advice(ref)='" + adviceReference.getBeanName() + "', pointcut(ref)='" + pointcutReference.getBeanName() + "'>";
    }

    public String getName() {
        return this.advisorBeanName;
    }

    public String getDescription() {
        return this.description;
    }

    public BeanDefinition[] getBeanDefinitions() {
        return this.beanDefinitions;
    }

    public RuntimeBeanReference[] getBeanReferences() {
        return this.beanReferences;
    }

    public Object getSource() {
        return this.advisorDefinition.getSource();
    }
}

