/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect.web.thymeleaf3;

import org.springframework.context.ApplicationContext;
import org.springframework.social.connect.ConnectionRepository;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.spring5.context.SpringContextUtils;
import org.thymeleaf.standard.processor.AbstractStandardConditionalVisibilityTagProcessor;
import org.thymeleaf.templatemode.TemplateMode;

class ConnectedAttrProcessor
extends AbstractStandardConditionalVisibilityTagProcessor {
    public ConnectedAttrProcessor() {
        super(TemplateMode.HTML, "social", "connected", 300);
    }

    protected boolean isVisible(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue) {
        String providerId = tag.getAttributeValue(attributeName);
        if (providerId == null || providerId.trim().equals("")) {
            return false;
        }
        ConnectionRepository connectionRepository = this.getConnectionRepository(context);
        return connectionRepository.findConnections(providerId).size() > 0;
    }

    private ConnectionRepository getConnectionRepository(ITemplateContext context) {
        ApplicationContext applicationContext = this.getSpringApplicationContextFromThymeleafContext(context);
        ConnectionRepository connectionRepository = (ConnectionRepository)applicationContext.getBean(ConnectionRepository.class);
        return connectionRepository;
    }

    private ApplicationContext getSpringApplicationContextFromThymeleafContext(ITemplateContext context) {
        return SpringContextUtils.getApplicationContext((ITemplateContext)context);
    }
}

