/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import org.springframework.social.twitter.api.StreamWarningEvent;
import org.springframework.social.twitter.api.impl.TwitterObjectMixin;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(using=StreamWarningEventDeserializer.class)
abstract class StreamWarningEventMixin
extends TwitterObjectMixin {
    StreamWarningEventMixin() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class StreamWarningEventDeserializer
    extends JsonDeserializer<StreamWarningEvent> {
        StreamWarningEventDeserializer() {
        }

        public StreamWarningEvent deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode warningNode = ((JsonNode)jp.readValueAs(JsonNode.class)).get("warning");
            return new StreamWarningEvent(warningNode.get("code").asText(), warningNode.get("message").asText(), warningNode.get("percent_full").asDouble());
        }
    }
}

