/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.converters;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.shell.converters.StaticFieldConverter;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.MethodTarget;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticFieldConverterImpl
implements StaticFieldConverter {
    private final Map<Class<?>, Map<String, Field>> fields = new HashMap();

    @Override
    public void add(Class<?> clazz) {
        Assert.notNull(clazz, (String)"A class to provide conversion services is required");
        Assert.isNull(this.fields.get(clazz), (String)("Class '" + clazz + "' is already registered for completion services"));
        HashMap<String, Field> ffields = new HashMap<String, Field>();
        for (Field field : clazz.getFields()) {
            int modifier = field.getModifiers();
            if (!Modifier.isStatic(modifier) || !Modifier.isPublic(modifier)) continue;
            ffields.put(field.getName(), field);
        }
        Assert.notEmpty(ffields, (String)("Zero public static fields accessible in '" + clazz + "'"));
        this.fields.put(clazz, ffields);
    }

    @Override
    public void remove(Class<?> clazz) {
        Assert.notNull(clazz, (String)"A class that was providing conversion services is required");
        this.fields.remove(clazz);
    }

    @Override
    public Object convertFromText(String value, Class<?> requiredType, String optionContext) {
        if (!StringUtils.hasText((String)value)) {
            return null;
        }
        Map<String, Field> ffields = this.fields.get(requiredType);
        if (ffields == null) {
            return null;
        }
        Field f = ffields.get(value);
        if (f == null) {
            for (Field candidate : ffields.values()) {
                if (!candidate.getName().equalsIgnoreCase(value)) continue;
                f = candidate;
                break;
            }
            if (f == null) {
                return null;
            }
        }
        try {
            return f.get(null);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to acquire field '" + value + "' from '" + requiredType.getName() + "'", ex);
        }
    }

    @Override
    public boolean getAllPossibleValues(List<Completion> completions, Class<?> requiredType, String existingData, String optionContext, MethodTarget target) {
        Map<String, Field> ffields = this.fields.get(requiredType);
        if (ffields == null) {
            return true;
        }
        for (String field : ffields.keySet()) {
            completions.add(new Completion(field));
        }
        return true;
    }

    @Override
    public boolean supports(Class<?> requiredType, String optionContext) {
        return this.fields.get(requiredType) != null;
    }
}

