/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.test.jediterm.terminal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.shell.test.jediterm.terminal.Terminal;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TerminalMode {
    Null,
    CursorKey{

        @Override
        public void setEnabled(Terminal terminal, boolean enabled) {
            terminal.setApplicationArrowKeys(enabled);
        }
    }
    ,
    ANSI,
    WideColumn{

        @Override
        public void setEnabled(Terminal terminal, boolean enabled) {
            terminal.clearScreen();
            terminal.resetScrollRegions();
        }
    }
    ,
    CursorVisible{

        @Override
        public void setEnabled(Terminal terminal, boolean enabled) {
            terminal.setCursorVisible(enabled);
        }
    }
    ,
    AlternateBuffer{

        @Override
        public void setEnabled(Terminal terminal, boolean enabled) {
            terminal.useAlternateBuffer(enabled);
        }
    }
    ,
    SmoothScroll,
    ReverseVideo,
    OriginMode{

        @Override
        public void setEnabled(Terminal terminal, boolean enabled) {
        }
    }
    ,
    AutoWrap{

        @Override
        public void setEnabled(Terminal terminal, boolean enabled) {
        }
    }
    ,
    AutoRepeatKeys,
    Interlace,
    Keypad{

        @Override
        public void setEnabled(Terminal terminal, boolean enabled) {
            terminal.setApplicationKeypad(enabled);
        }
    }
    ,
    StoreCursor{

        @Override
        public void setEnabled(Terminal terminal, boolean enabled) {
            if (enabled) {
                terminal.saveCursor();
            } else {
                terminal.restoreCursor();
            }
        }
    }
    ,
    CursorBlinking{

        @Override
        public void setEnabled(Terminal terminal, boolean enabled) {
            terminal.setBlinkingCursor(enabled);
        }
    }
    ,
    AllowWideColumn,
    ReverseWrapAround,
    AutoNewLine{

        @Override
        public void setEnabled(Terminal terminal, boolean enabled) {
            terminal.setAutoNewLine(enabled);
        }
    }
    ,
    KeyboardAction,
    InsertMode,
    SendReceive,
    EightBitInput,
    AltSendsEscape{

        @Override
        public void setEnabled(Terminal terminal, boolean enabled) {
            terminal.setAltSendsEscape(enabled);
        }
    }
    ,
    BracketedPasteMode{

        @Override
        public void setEnabled(Terminal terminal, boolean enabled) {
            terminal.setBracketedPasteMode(enabled);
        }
    };

    private static final Log log;

    public void setEnabled(Terminal terminal, boolean enabled) {
        log.warn((Object)("Mode " + this.name() + " is not implemented, setting to " + enabled));
    }

    static {
        log = LogFactory.getLog(TerminalMode.class);
    }
}

