/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.table;

import org.springframework.shell.jline.tui.table.Aligner;

public class KeyValueHorizontalAligner
implements Aligner {
    private final String delimiter;

    public KeyValueHorizontalAligner(String delimiter) {
        this.delimiter = delimiter;
    }

    @Override
    public String[] align(String[] text, int cellWidth, int cellHeight) {
        String[] result = new String[cellHeight];
        int alignOffset = 0;
        for (String line : text) {
            alignOffset = Math.max(alignOffset, line.trim().indexOf(this.delimiter));
        }
        int i = 0;
        for (String line : text) {
            String trimmed = line.trim();
            int offset = trimmed.indexOf(this.delimiter);
            if (offset >= 0) {
                int offsetToUse = Math.min(alignOffset - offset, cellWidth - trimmed.length());
                result[i++] = this.pad(offsetToUse, cellWidth - trimmed.length() - offsetToUse, trimmed);
                continue;
            }
            result[i++] = this.pad(0, cellWidth - line.length(), line);
        }
        return result;
    }

    private String pad(int left, int right, String original) {
        int i;
        StringBuilder sb = new StringBuilder(left + original.length() + right);
        for (i = 0; i < left; ++i) {
            sb.append(' ');
        }
        sb.append(original);
        for (i = 0; i < right; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }
}

