/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.table;

import java.util.HashMap;
import java.util.Map;

public enum BorderStyle {
    oldschool('|', '-'),
    fancy_light('\u2502', '\u2500'),
    fancy_heavy('\u2503', '\u2501'),
    fancy_double('\u2551', '\u2550'),
    air(' ', ' '),
    fancy_light_double_dash('\u254e', '\u254c'),
    fancy_light_triple_dash('\u2506', '\u2504'),
    fancy_light_quadruple_dash('\u250a', '\u2508'),
    fancy_heavy_double_dash('\u254f', '\u254d'),
    fancy_heavy_triple_dash('\u2507', '\u2505'),
    fancy_heavy_quadruple_dash('\u250b', '\u2509');

    private char vertical;
    private char horizontal;
    public static final char NONE = '\u0000';
    private static Map<Long, Character> CORNERS;
    private static Map<Character, Character> EQUIVALENTS;

    public char verticalGlyph() {
        return this.vertical;
    }

    public char horizontalGlyph() {
        return this.horizontal;
    }

    private static void registerSameCorners(BorderStyle style1, BorderStyle style2) {
        EQUIVALENTS.put(Character.valueOf(style1.horizontal), Character.valueOf(style2.horizontal));
        EQUIVALENTS.put(Character.valueOf(style1.vertical), Character.valueOf(style2.vertical));
    }

    private static void registerMixedWithAirCombinations(char vertical, char horizontal) {
        BorderStyle.registerCorner(vertical, vertical, ' ', '\u0000', vertical);
        BorderStyle.registerCorner(vertical, vertical, '\u0000', ' ', vertical);
        BorderStyle.registerCorner(vertical, vertical, ' ', ' ', vertical);
        BorderStyle.registerCorner(' ', '\u0000', horizontal, horizontal, horizontal);
        BorderStyle.registerCorner('\u0000', ' ', horizontal, horizontal, horizontal);
        BorderStyle.registerCorner(' ', ' ', horizontal, horizontal, horizontal);
    }

    private static void registerCorners(String list) {
        char horizontal = list.charAt(0);
        char vertical = list.charAt(1);
        BorderStyle.registerCorner('\u0000', vertical, '\u0000', horizontal, list.charAt(2));
        BorderStyle.registerCorner('\u0000', vertical, horizontal, '\u0000', list.charAt(3));
        BorderStyle.registerCorner(vertical, '\u0000', '\u0000', horizontal, list.charAt(4));
        BorderStyle.registerCorner(vertical, '\u0000', horizontal, '\u0000', list.charAt(5));
        BorderStyle.registerCorner(vertical, vertical, '\u0000', horizontal, list.charAt(6));
        BorderStyle.registerCorner(vertical, vertical, horizontal, '\u0000', list.charAt(7));
        BorderStyle.registerCorner('\u0000', vertical, horizontal, horizontal, list.charAt(8));
        BorderStyle.registerCorner(vertical, '\u0000', horizontal, horizontal, list.charAt(9));
        BorderStyle.registerCorner(vertical, vertical, horizontal, horizontal, list.charAt(10));
    }

    private static void registerCorner(char above, char below, char left, char right, char corner) {
        long key = BorderStyle.key(above, below, left, right);
        CORNERS.put(key, Character.valueOf(corner));
    }

    public static char intersection(char above, char below, char left, char right) {
        above = EQUIVALENTS.get(Character.valueOf(above)) != null ? EQUIVALENTS.get(Character.valueOf(above)).charValue() : above;
        below = EQUIVALENTS.get(Character.valueOf(below)) != null ? EQUIVALENTS.get(Character.valueOf(below)).charValue() : below;
        left = EQUIVALENTS.get(Character.valueOf(left)) != null ? EQUIVALENTS.get(Character.valueOf(left)).charValue() : left;
        right = EQUIVALENTS.get(Character.valueOf(right)) != null ? EQUIVALENTS.get(Character.valueOf(right)).charValue() : right;
        Character character = CORNERS.get(BorderStyle.key(above, below, left, right));
        return character != null ? character.charValue() : (char)'\u0000';
    }

    private static long key(char above, char below, char left, char right) {
        return (long)above << 48 | (long)below << 32 | (long)left << 16 | (long)right;
    }

    private BorderStyle(char vertical, char horizontal) {
        this.vertical = vertical;
        this.horizontal = horizontal;
    }

    static {
        CORNERS = new HashMap<Long, Character>();
        EQUIVALENTS = new HashMap<Character, Character>();
        BorderStyle.registerCorners("\u2500\u2502\u250c\u2510\u2514\u2518\u251c\u2524\u252c\u2534\u253c");
        BorderStyle.registerCorners("\u2501\u2503\u250f\u2513\u2517\u251b\u2523\u252b\u2533\u253b\u254b");
        BorderStyle.registerCorners("\u254c\u254e\u250c\u2510\u2514\u2518\u251c\u2524\u252c\u2534\u253c");
        BorderStyle.registerCorners("\u254d\u254f\u250f\u2513\u2517\u251b\u2523\u252b\u2533\u253b\u254b");
        BorderStyle.registerCorners("\u2508\u2506\u250c\u2510\u2514\u2518\u251c\u2524\u252c\u2534\u253c");
        BorderStyle.registerCorners("\u2505\u2507\u250f\u2513\u2517\u251b\u2523\u252b\u2533\u253b\u254b");
        BorderStyle.registerCorners("\u2508\u250a\u250c\u2510\u2514\u2518\u251c\u2524\u252c\u2534\u253c");
        BorderStyle.registerCorners("\u2509\u250b\u250f\u2513\u2517\u251b\u2523\u252b\u2533\u253b\u254b");
        BorderStyle.registerCorners("\u2550\u2551\u2554\u2557\u255a\u255d\u2560\u2563\u2566\u2569\u256c");
        BorderStyle.registerCorners("-|+++++++++");
        BorderStyle.registerCorners("           ");
        BorderStyle.registerCorner('\u2502', '\u2502', '\u2501', '\u0000', '\u2525');
        BorderStyle.registerCorner('\u2502', '\u2502', '\u0000', '\u2501', '\u251d');
        BorderStyle.registerCorner('\u2503', '\u0000', '\u2500', '\u2500', '\u2538');
        BorderStyle.registerCorner('\u0000', '\u2503', '\u2500', '\u2500', '\u2530');
        BorderStyle.registerCorner('\u2503', '\u2503', '\u2500', '\u0000', '\u2528');
        BorderStyle.registerCorner('\u2503', '\u2503', '\u0000', '\u2500', '\u2520');
        BorderStyle.registerCorner('\u2502', '\u0000', '\u2501', '\u2501', '\u2537');
        BorderStyle.registerCorner('\u0000', '\u2502', '\u2501', '\u2501', '\u252f');
        BorderStyle.registerCorner('\u2551', '\u2551', '\u2500', '\u0000', '\u2562');
        BorderStyle.registerCorner('\u2551', '\u2551', '\u0000', '\u2500', '\u255f');
        BorderStyle.registerCorner('\u2502', '\u0000', '\u2550', '\u2550', '\u2567');
        BorderStyle.registerCorner('\u0000', '\u2502', '\u2550', '\u2550', '\u2564');
        BorderStyle.registerCorner('\u2502', '\u2502', '\u2550', '\u0000', '\u2561');
        BorderStyle.registerCorner('\u2502', '\u2502', '\u0000', '\u2550', '\u255e');
        BorderStyle.registerCorner('\u2551', '\u0000', '\u2500', '\u2500', '\u2568');
        BorderStyle.registerCorner('\u0000', '\u2551', '\u2500', '\u2500', '\u2565');
        BorderStyle.registerCorner('\u2503', '\u2502', '\u2501', '\u2500', '\u2543');
        BorderStyle.registerCorner('\u2502', '\u2503', '\u2500', '\u2501', '\u2546');
        BorderStyle.registerCorner('\u2503', '\u2502', '\u2500', '\u2501', '\u2544');
        BorderStyle.registerCorner('\u2502', '\u2503', '\u2501', '\u2500', '\u2545');
        BorderStyle.registerCorner('\u2502', '\u2502', '\u2501', '\u2501', '\u253f');
        BorderStyle.registerCorner('\u2502', '\u2502', '\u2550', '\u2550', '\u256a');
        BorderStyle.registerCorner('\u2503', '\u2503', '\u2500', '\u2500', '\u2542');
        BorderStyle.registerCorner('\u2551', '\u2551', '\u2500', '\u2500', '\u256b');
        BorderStyle.registerSameCorners(fancy_light_double_dash, fancy_light);
        BorderStyle.registerSameCorners(fancy_light_triple_dash, fancy_light);
        BorderStyle.registerSameCorners(fancy_light_quadruple_dash, fancy_light);
        BorderStyle.registerSameCorners(fancy_heavy_double_dash, fancy_heavy);
        BorderStyle.registerSameCorners(fancy_heavy_triple_dash, fancy_heavy);
        BorderStyle.registerSameCorners(fancy_heavy_quadruple_dash, fancy_heavy);
        BorderStyle.registerMixedWithAirCombinations(BorderStyle.oldschool.vertical, BorderStyle.oldschool.horizontal);
        BorderStyle.registerMixedWithAirCombinations(BorderStyle.fancy_light.vertical, BorderStyle.fancy_light.horizontal);
        BorderStyle.registerMixedWithAirCombinations(BorderStyle.fancy_double.vertical, BorderStyle.fancy_double.horizontal);
        BorderStyle.registerMixedWithAirCombinations(BorderStyle.fancy_heavy.vertical, BorderStyle.fancy_heavy.horizontal);
        BorderStyle.registerMixedWithAirCombinations(BorderStyle.fancy_light_double_dash.vertical, BorderStyle.fancy_light_double_dash.horizontal);
        BorderStyle.registerMixedWithAirCombinations(BorderStyle.fancy_light_triple_dash.vertical, BorderStyle.fancy_light_triple_dash.horizontal);
        BorderStyle.registerMixedWithAirCombinations(BorderStyle.fancy_light_quadruple_dash.vertical, BorderStyle.fancy_light_quadruple_dash.horizontal);
        BorderStyle.registerMixedWithAirCombinations(BorderStyle.fancy_heavy_double_dash.vertical, BorderStyle.fancy_heavy_double_dash.horizontal);
        BorderStyle.registerMixedWithAirCombinations(BorderStyle.fancy_heavy_triple_dash.vertical, BorderStyle.fancy_heavy_triple_dash.horizontal);
        BorderStyle.registerMixedWithAirCombinations(BorderStyle.fancy_heavy_quadruple_dash.vertical, BorderStyle.fancy_heavy_quadruple_dash.horizontal);
    }
}

