/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline;

import java.io.PrintWriter;
import org.jline.reader.LineReader;
import org.springframework.shell.core.InputProvider;
import org.springframework.shell.core.InputReader;
import org.springframework.shell.core.InteractiveShellRunner;
import org.springframework.shell.core.command.CommandParser;
import org.springframework.shell.core.command.CommandRegistry;
import org.springframework.shell.jline.JLineInputProvider;
import org.springframework.shell.jline.JLineInputReader;

public class JLineShellRunner
extends InteractiveShellRunner {
    private final LineReader lineReader;

    public JLineShellRunner(JLineInputProvider inputProvider, CommandParser commandParser, CommandRegistry commandRegistry) {
        super((InputProvider)inputProvider, commandParser, commandRegistry);
        this.lineReader = inputProvider.getLineReader();
    }

    public void print(String message) {
        this.lineReader.getTerminal().writer().println(message);
    }

    public void flush() {
        this.lineReader.getTerminal().flush();
    }

    public PrintWriter getWriter() {
        return this.lineReader.getTerminal().writer();
    }

    public InputReader getReader() {
        return new JLineInputReader(this.lineReader);
    }
}

