/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.component.view.control;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.shell.jline.tui.component.message.ShellMessageBuilder;
import org.springframework.shell.jline.tui.component.view.control.BoxView;
import org.springframework.shell.jline.tui.component.view.control.View;
import org.springframework.shell.jline.tui.component.view.control.ViewEvent;
import org.springframework.shell.jline.tui.component.view.control.ViewEventArgs;
import org.springframework.shell.jline.tui.component.view.event.MouseEvent;
import org.springframework.shell.jline.tui.component.view.event.MouseHandler;
import org.springframework.shell.jline.tui.component.view.screen.Screen;
import org.springframework.shell.jline.tui.geom.Rectangle;
import org.springframework.util.StringUtils;

public class StatusBarView
extends BoxView {
    private final Log log = LogFactory.getLog(StatusBarView.class);
    private final List<StatusItem> items = new ArrayList<StatusItem>();
    private @Nullable String itemSeparator = " | ";

    public StatusBarView() {
        this(new StatusItem[0]);
    }

    public StatusBarView(StatusItem[] items) {
        this(Arrays.asList(items));
    }

    public StatusBarView(List<StatusItem> items) {
        this.setItems(items);
    }

    @Override
    protected String getBackgroundStyle() {
        return "style-statusbar-background";
    }

    public @Nullable String getItemSeparator() {
        return this.itemSeparator;
    }

    public void setItemSeparator(@Nullable String itemSeparator) {
        this.itemSeparator = itemSeparator;
    }

    @Override
    protected void drawInternal(Screen screen) {
        Rectangle rect = this.getInnerRect();
        this.log.debug((Object)("Drawing status bar to " + String.valueOf(rect)));
        Screen.Writer writer = screen.writerBuilder().build();
        int primaryX = rect.x();
        int nonprimaryX = rect.x() + rect.width();
        boolean primaryWritten = false;
        boolean nonprimaryWritten = false;
        ListIterator<StatusItem> iter = this.items.listIterator();
        while (iter.hasNext()) {
            StatusItem item = iter.next();
            Object text = item.getTitle();
            if (text == null) continue;
            String sep = this.getItemSeparator();
            if (nonprimaryX - primaryX < ((String)text).length() + (sep != null ? sep.length() : 0)) break;
            if (item.primary) {
                if (primaryWritten && StringUtils.hasText((String)sep)) {
                    text = sep + (String)text;
                }
                writer.text((String)text, primaryX, rect.y());
                primaryX += ((String)text).length();
                primaryWritten = true;
                continue;
            }
            if (nonprimaryWritten && StringUtils.hasText((String)sep)) {
                text = (String)text + sep;
            }
            writer.text((String)text, nonprimaryX - ((String)text).length(), rect.y());
            nonprimaryX -= ((String)text).length();
            nonprimaryWritten = true;
        }
        super.drawInternal(screen);
    }

    @Override
    public MouseHandler getMouseHandler() {
        this.log.trace((Object)"getMouseHandler()");
        return args -> {
            MouseEvent event = args.event();
            boolean consumed = false;
            if (!event.hasModifier() && event.has(1) && event.has(64)) {
                int y;
                int x = event.x();
                StatusItem item = this.itemAt(x, y = event.y());
                if (item != null) {
                    this.dispatch(ShellMessageBuilder.ofView(this, StatusBarViewOpenSelectedItemEvent.of(this, item)));
                    if (item.getAction() != null) {
                        this.dispatchRunnable(item.getAction());
                    }
                }
                consumed = true;
            }
            return MouseHandler.resultOf(args.event(), consumed, null, null);
        };
    }

    private @Nullable StatusItem itemAt(int x, int y) {
        Rectangle rect = this.getRect();
        if (!rect.contains(x, y)) {
            return null;
        }
        int ix = 0;
        for (StatusItem item : this.items) {
            String title = item.getTitle();
            if (!StringUtils.hasText((String)title)) continue;
            if (x < ix + title.length()) {
                return item;
            }
            ix += title.length();
        }
        return null;
    }

    public void setItems(List<StatusItem> items) {
        this.items.clear();
        this.items.addAll(items);
        Collections.sort(this.items, (o1, o2) -> {
            int ret = o1.priority - o2.priority;
            if (ret == 0) {
                if (o1.primary && !o2.primary) {
                    ret = -1;
                } else if (!o1.primary && o2.primary) {
                    ret = 1;
                }
            }
            return ret;
        });
        this.registerHotKeys();
    }

    public List<StatusItem> getItems() {
        return this.items;
    }

    private void registerHotKeys() {
        this.getItems().stream().filter(item -> item.getHotKey() != null).forEach(item -> {
            Runnable action = item.getAction();
            if (action != null) {
                this.registerHotKeyBinding(item.getHotKey(), action);
            }
        });
    }

    public static class StatusItem {
        private String title;
        private @Nullable Runnable action;
        private @Nullable Integer hotKey;
        private boolean primary = true;
        private int priority = 0;

        public StatusItem(String title) {
            this(title, null);
        }

        public StatusItem(String title, @Nullable Runnable action) {
            this(title, action, null);
        }

        public StatusItem(String title, @Nullable Runnable action, @Nullable Integer hotKey) {
            this.title = title;
            this.action = action;
            this.hotKey = hotKey;
        }

        public StatusItem(String title, Runnable action, Integer hotKey, boolean primary, int priority) {
            this.title = title;
            this.action = action;
            this.hotKey = hotKey;
            this.primary = primary;
            this.priority = priority;
        }

        public static StatusItem of(String title) {
            return new StatusItem(title);
        }

        public static StatusItem of(String title, Runnable action) {
            return new StatusItem(title, action);
        }

        public static StatusItem of(String title, Runnable action, Integer hotKey) {
            return new StatusItem(title, action, hotKey);
        }

        public static StatusItem of(String title, Runnable action, Integer hotKey, boolean primary, int priority) {
            return new StatusItem(title, action, hotKey, primary, priority);
        }

        public @Nullable String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public @Nullable Runnable getAction() {
            return this.action;
        }

        public StatusItem setAction(Runnable action) {
            this.action = action;
            return this;
        }

        public @Nullable Integer getHotKey() {
            return this.hotKey;
        }

        public StatusItem setHotKey(Integer hotKey) {
            this.hotKey = hotKey;
            return this;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public boolean isPrimary() {
            return this.primary;
        }

        public void setPrimary(boolean primary) {
            this.primary = primary;
        }
    }

    public static final class StatusBarViewOpenSelectedItemEvent
    extends Record
    implements ViewEvent {
        private final View view;
        private final StatusBarViewItemEventArgs args;

        public StatusBarViewOpenSelectedItemEvent(View view, StatusBarViewItemEventArgs args) {
            this.view = view;
            this.args = args;
        }

        public static StatusBarViewOpenSelectedItemEvent of(View view, StatusItem item) {
            return new StatusBarViewOpenSelectedItemEvent(view, StatusBarViewItemEventArgs.of(item));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{StatusBarViewOpenSelectedItemEvent.class, "view;args", "view", "args"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{StatusBarViewOpenSelectedItemEvent.class, "view;args", "view", "args"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{StatusBarViewOpenSelectedItemEvent.class, "view;args", "view", "args"}, this, o);
        }

        @Override
        public View view() {
            return this.view;
        }

        @Override
        public StatusBarViewItemEventArgs args() {
            return this.args;
        }
    }

    public record StatusBarViewItemEventArgs(StatusItem item) implements ViewEventArgs
    {
        public static StatusBarViewItemEventArgs of(StatusItem item) {
            return new StatusBarViewItemEventArgs(item);
        }
    }
}

