/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline;

import org.jline.reader.LineReader;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;
import org.springframework.shell.core.InputProvider;
import org.springframework.shell.jline.PromptProvider;

public class JLineInputProvider
implements InputProvider {
    private final LineReader lineReader;
    private PromptProvider promptProvider = () -> new AttributedString((CharSequence)"shell:>", AttributedStyle.DEFAULT.foreground(3));

    public JLineInputProvider(LineReader lineReader) {
        this.lineReader = lineReader;
    }

    public String readInput() {
        AttributedString prompt = this.promptProvider.getPrompt();
        String ansiPrompt = prompt.toAnsi(this.lineReader.getTerminal());
        return this.lineReader.readLine(ansiPrompt);
    }

    public void setPromptProvider(PromptProvider promptProvider) {
        this.promptProvider = promptProvider;
    }

    public Terminal getTerminal() {
        return this.lineReader.getTerminal();
    }
}

