/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline;

import java.util.List;
import java.util.Set;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.springframework.shell.core.command.Command;
import org.springframework.shell.core.command.CommandRegistry;
import org.springframework.shell.core.command.completion.CompletionContext;
import org.springframework.shell.core.command.completion.CompletionProposal;
import org.springframework.shell.core.command.completion.CompletionProvider;

public class CommandCompleter
implements Completer {
    private final CommandRegistry commandRegistry;

    public CommandCompleter(CommandRegistry commandRegistry) {
        this.commandRegistry = commandRegistry;
    }

    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        Set commands = this.commandRegistry.getCommands();
        if (this.commandRegistry.getCommandByName(line.word().trim()) != null) {
            Command command = this.commandRegistry.getCommandByName(line.word().trim());
            CompletionProvider completionProvider = command.getCompletionProvider();
            CompletionContext context = new CompletionContext(line.words(), line.wordIndex(), line.wordCursor(), null, null);
            List proposals = (List)completionProvider.apply((Object)context);
            for (CompletionProposal proposal : proposals) {
                candidates.add(new Candidate(proposal.value()));
            }
        } else {
            for (Command command : commands) {
                candidates.add(new Candidate(command.getName(), command.getName() + ": " + command.getDescription(), command.getGroup(), command.getHelp(), null, null, true));
            }
        }
    }
}

