/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.jline.tui.component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jline.keymap.BindingReader;
import org.jline.keymap.KeyMap;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jspecify.annotations.Nullable;
import org.springframework.shell.jline.tui.component.context.ComponentContext;
import org.springframework.shell.jline.tui.component.support.AbstractTextComponent;
import org.springframework.util.StringUtils;

public class StringInput
extends AbstractTextComponent<String, StringInputContext> {
    private static final Log log = LogFactory.getLog(StringInput.class);
    private final @Nullable String defaultValue;
    private @Nullable StringInputContext currentContext;
    private @Nullable Character maskCharacter;
    private boolean required;

    public StringInput(Terminal terminal) {
        this(terminal, null, null, null, false);
    }

    public StringInput(Terminal terminal, @Nullable String name, @Nullable String defaultValue) {
        this(terminal, name, defaultValue, null, false);
    }

    public StringInput(Terminal terminal, @Nullable String name, @Nullable String defaultValue, @Nullable Function<StringInputContext, List<AttributedString>> renderer) {
        this(terminal, name, defaultValue, renderer, false);
    }

    public StringInput(Terminal terminal, @Nullable String name, @Nullable String defaultValue, @Nullable Function<StringInputContext, List<AttributedString>> renderer, boolean required) {
        super(terminal, name, null);
        this.setRenderer(renderer != null ? renderer : new DefaultRenderer());
        this.setTemplateLocation("classpath:org/springframework/shell/component/string-input-default.stg");
        this.defaultValue = defaultValue;
        this.required = required;
    }

    public void setMaskCharacter(@Nullable Character maskCharacter) {
        this.maskCharacter = maskCharacter;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public StringInputContext getThisContext(@Nullable ComponentContext<?> context) {
        if (context != null && this.currentContext == context) {
            return this.currentContext;
        }
        this.currentContext = StringInputContext.of(this.defaultValue, this.maskCharacter, this.required);
        this.currentContext.setName(this.getName());
        if (context != null) {
            context.stream().forEach(e -> this.currentContext.put(e.getKey(), e.getValue()));
        }
        return this.currentContext;
    }

    @Override
    protected boolean read(BindingReader bindingReader, KeyMap<String> keyMap, StringInputContext context) {
        String operation = (String)bindingReader.readBinding(keyMap);
        log.debug((Object)("Binding read result " + operation));
        if (operation == null) {
            return true;
        }
        switch (operation) {
            case "UNICODE": 
            case "CHAR": {
                String lastBinding = bindingReader.getLastBinding();
                Object input = context.getInput();
                input = input == null ? lastBinding : (String)input + lastBinding;
                context.setInput((String)input);
                break;
            }
            case "BACKSPACE": {
                String input = context.getInput();
                if (StringUtils.hasLength((String)input)) {
                    String string = input = input.length() > 1 ? input.substring(0, input.length() - 1) : null;
                }
                if (input == null) break;
                context.setInput(input);
                break;
            }
            case "EXIT": {
                if (StringUtils.hasText((String)context.getInput())) {
                    context.setResultValue(context.getInput());
                } else if (context.getDefaultValue() != null) {
                    context.setResultValue(context.getDefaultValue());
                } else if (this.required) {
                    context.setMessage("This field is mandatory", AbstractTextComponent.TextComponentContext.MessageLevel.ERROR);
                    break;
                }
                return true;
            }
        }
        return false;
    }

    private class DefaultRenderer
    implements Function<StringInputContext, List<AttributedString>> {
        private DefaultRenderer() {
        }

        @Override
        public List<AttributedString> apply(StringInputContext context) {
            return StringInput.this.renderTemplateResource(context.toTemplateModel());
        }
    }

    public static interface StringInputContext
    extends AbstractTextComponent.TextComponentContext<String, StringInputContext> {
        public @Nullable String getDefaultValue();

        public void setDefaultValue(@Nullable String var1);

        public void setMaskCharacter(Character var1);

        public @Nullable String getMaskedInput();

        public @Nullable String getMaskedResultValue();

        public boolean hasMaskCharacter();

        public @Nullable Character getMaskCharacter();

        public void setRequired(boolean var1);

        public boolean isRequired();

        public static StringInputContext empty() {
            return StringInputContext.of(null, null, false);
        }

        public static StringInputContext of(@Nullable String defaultValue, @Nullable Character maskCharacter) {
            return StringInputContext.of(defaultValue, maskCharacter, false);
        }

        public static StringInputContext of(@Nullable String defaultValue, @Nullable Character maskCharacter, boolean required) {
            return new DefaultStringInputContext(defaultValue, maskCharacter, required);
        }
    }

    private static class DefaultStringInputContext
    extends AbstractTextComponent.BaseTextComponentContext<String, StringInputContext>
    implements StringInputContext {
        private @Nullable String defaultValue;
        private @Nullable Character maskCharacter;
        private boolean required;

        public DefaultStringInputContext(@Nullable String defaultValue, @Nullable Character maskCharacter, boolean required) {
            this.defaultValue = defaultValue;
            this.maskCharacter = maskCharacter;
            this.required = required;
        }

        @Override
        public @Nullable String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public void setDefaultValue(@Nullable String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public void setMaskCharacter(Character maskCharacter) {
            this.maskCharacter = maskCharacter;
        }

        @Override
        public void setRequired(boolean required) {
            this.required = required;
        }

        @Override
        public @Nullable String getMaskedInput() {
            return this.maybeMask(this.getInput());
        }

        @Override
        public @Nullable String getMaskedResultValue() {
            return this.maybeMask((String)this.getResultValue());
        }

        @Override
        public boolean hasMaskCharacter() {
            return this.maskCharacter != null;
        }

        @Override
        public @Nullable Character getMaskCharacter() {
            return this.maskCharacter;
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }

        @Override
        public Map<String, @Nullable Object> toTemplateModel() {
            Map<String, @Nullable Object> attributes = super.toTemplateModel();
            attributes.put("defaultValue", this.getDefaultValue() != null ? this.getDefaultValue() : null);
            attributes.put("maskedInput", this.getMaskedInput());
            attributes.put("maskedResultValue", this.getMaskedResultValue());
            attributes.put("maskCharacter", this.getMaskCharacter());
            attributes.put("hasMaskCharacter", this.hasMaskCharacter());
            attributes.put("required", this.isRequired());
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("model", attributes);
            return model;
        }

        private @Nullable String maybeMask(@Nullable String str) {
            if (StringUtils.hasLength((String)str) && this.maskCharacter != null) {
                return new String(new char[str.length()]).replace('\u0000', this.maskCharacter.charValue());
            }
            return str;
        }
    }
}

