/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.boot;

import org.jline.terminal.Terminal;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;
import org.springframework.shell.jline.tui.component.ViewComponentBuilder;
import org.springframework.shell.jline.tui.component.ViewComponentExecutor;
import org.springframework.shell.jline.tui.component.view.TerminalUI;
import org.springframework.shell.jline.tui.component.view.TerminalUIBuilder;
import org.springframework.shell.jline.tui.component.view.TerminalUICustomizer;
import org.springframework.shell.jline.tui.style.ThemeActive;
import org.springframework.shell.jline.tui.style.ThemeResolver;

@AutoConfiguration
@ConditionalOnClass(value={TerminalUI.class})
public class TerminalUIAutoConfiguration {
    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean
    public TerminalUIBuilder terminalUIBuilder(Terminal terminal, ThemeResolver themeResolver, ThemeActive themeActive, ObjectProvider<TerminalUICustomizer> customizerProvider) {
        TerminalUIBuilder builder = new TerminalUIBuilder(terminal, new TerminalUICustomizer[0]);
        builder = builder.themeName((String)themeActive.get());
        builder = builder.themeResolver(themeResolver);
        builder = builder.customizers(customizerProvider.orderedStream().toList());
        return builder;
    }

    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean
    public ViewComponentBuilder viewComponentBuilder(TerminalUIBuilder terminalUIBuilder, ViewComponentExecutor viewComponentExecutor, Terminal terminal) {
        return new ViewComponentBuilder(terminalUIBuilder, viewComponentExecutor, terminal);
    }

    @Bean
    @ConditionalOnMissingBean
    public ViewComponentExecutor viewComponentExecutor() {
        return new ViewComponentExecutor();
    }
}

