/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.boot;

import org.jline.terminal.Terminal;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.ResourceLoader;
import org.springframework.shell.boot.ComponentFlowCustomizer;
import org.springframework.shell.jline.tui.component.flow.ComponentFlow;
import org.springframework.shell.jline.tui.style.TemplateExecutor;

@AutoConfiguration
@ConditionalOnClass(value={ComponentFlow.class})
public class ComponentFlowAutoConfiguration {
    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean
    public ComponentFlow.Builder componentFlowBuilder(ObjectProvider<ComponentFlowCustomizer> customizerProvider) {
        ComponentFlow.Builder builder = ComponentFlow.builder();
        customizerProvider.orderedStream().forEach(customizer -> customizer.customize(builder));
        return builder;
    }

    private static class CommonComponentFlowCustomizer
    implements ComponentFlowCustomizer {
        private final ObjectProvider<Terminal> terminal;
        private final ObjectProvider<ResourceLoader> resourceLoader;
        private final ObjectProvider<TemplateExecutor> templateExecutor;

        CommonComponentFlowCustomizer(ObjectProvider<Terminal> terminal, ObjectProvider<ResourceLoader> resourceLoader, ObjectProvider<TemplateExecutor> templateExecutor) {
            this.terminal = terminal;
            this.resourceLoader = resourceLoader;
            this.templateExecutor = templateExecutor;
        }

        @Override
        public void customize(ComponentFlow.Builder componentFlowBuilder) {
            this.terminal.ifAvailable(dep -> componentFlowBuilder.terminal(dep));
            this.resourceLoader.ifAvailable(dep -> componentFlowBuilder.resourceLoader(dep));
            this.templateExecutor.ifAvailable(dep -> componentFlowBuilder.templateExecutor(dep));
        }
    }

    @Configuration(proxyBeanMethods=false)
    protected static class ComponentFlowConfiguration {
        protected ComponentFlowConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @Order(value=0)
        public ComponentFlowCustomizer shellCommonComponentFlowCustomizer(ObjectProvider<Terminal> terminal, ObjectProvider<ResourceLoader> resourceLoader, ObjectProvider<TemplateExecutor> templateExecutor) {
            return new CommonComponentFlowCustomizer(terminal, resourceLoader, templateExecutor);
        }
    }
}

