/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.web.http;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.session.Session;
import org.springframework.session.web.http.HttpSessionStrategy;
import org.springframework.util.Assert;

public class HeaderHttpSessionStrategy
implements HttpSessionStrategy {
    private String headerName = "X-Auth-Token";

    @Override
    public String getRequestedSessionId(HttpServletRequest request) {
        return request.getHeader(this.headerName);
    }

    @Override
    public void onNewSession(Session session, HttpServletRequest request, HttpServletResponse response) {
        response.setHeader(this.headerName, session.getId());
    }

    @Override
    public void onInvalidateSession(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader(this.headerName, "");
    }

    public void setHeaderName(String headerName) {
        Assert.notNull((Object)headerName, (String)"headerName cannot be null");
        this.headerName = headerName;
    }
}

