/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.hazelcast.config.annotation.web.http;

import com.hazelcast.core.HazelcastInstance;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.FlushMode;
import org.springframework.session.IndexResolver;
import org.springframework.session.MapSession;
import org.springframework.session.SaveMode;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;
import org.springframework.session.config.SessionRepositoryCustomizer;
import org.springframework.session.config.annotation.web.http.SpringHttpSessionConfiguration;
import org.springframework.session.hazelcast.HazelcastIndexedSessionRepository;
import org.springframework.session.hazelcast.config.annotation.SpringSessionHazelcastInstance;
import org.springframework.session.hazelcast.config.annotation.web.http.EnableHazelcastHttpSession;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@Import(value={SpringHttpSessionConfiguration.class})
public class HazelcastHttpSessionConfiguration
implements ImportAware {
    private Duration maxInactiveInterval = MapSession.DEFAULT_MAX_INACTIVE_INTERVAL;
    private String sessionMapName = "spring:session:sessions";
    private FlushMode flushMode = FlushMode.ON_SAVE;
    private SaveMode saveMode = SaveMode.ON_SET_ATTRIBUTE;
    private HazelcastInstance hazelcastInstance;
    private ApplicationEventPublisher applicationEventPublisher;
    private IndexResolver<Session> indexResolver;
    private List<SessionRepositoryCustomizer<HazelcastIndexedSessionRepository>> sessionRepositoryCustomizers;

    @Bean
    public FindByIndexNameSessionRepository<?> sessionRepository() {
        return this.createHazelcastIndexedSessionRepository();
    }

    public void setMaxInactiveInterval(Duration maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    @Deprecated
    public void setMaxInactiveIntervalInSeconds(int maxInactiveIntervalInSeconds) {
        this.setMaxInactiveInterval(Duration.ofSeconds(maxInactiveIntervalInSeconds));
    }

    public void setSessionMapName(String sessionMapName) {
        this.sessionMapName = sessionMapName;
    }

    public void setFlushMode(FlushMode flushMode) {
        this.flushMode = flushMode;
    }

    public void setSaveMode(SaveMode saveMode) {
        this.saveMode = saveMode;
    }

    @Autowired
    public void setHazelcastInstance(@SpringSessionHazelcastInstance ObjectProvider<HazelcastInstance> springSessionHazelcastInstance, ObjectProvider<HazelcastInstance> hazelcastInstance) {
        HazelcastInstance hazelcastInstanceToUse = (HazelcastInstance)springSessionHazelcastInstance.getIfAvailable();
        if (hazelcastInstanceToUse == null) {
            hazelcastInstanceToUse = (HazelcastInstance)hazelcastInstance.getObject();
        }
        this.hazelcastInstance = hazelcastInstanceToUse;
    }

    @Autowired
    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Autowired(required=false)
    public void setIndexResolver(IndexResolver<Session> indexResolver) {
        this.indexResolver = indexResolver;
    }

    @Autowired(required=false)
    public void setSessionRepositoryCustomizer(ObjectProvider<SessionRepositoryCustomizer<HazelcastIndexedSessionRepository>> sessionRepositoryCustomizers) {
        this.sessionRepositoryCustomizers = sessionRepositoryCustomizers.orderedStream().collect(Collectors.toList());
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        Map attributeMap = importMetadata.getAnnotationAttributes(EnableHazelcastHttpSession.class.getName());
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)attributeMap);
        if (attributes == null) {
            return;
        }
        this.maxInactiveInterval = Duration.ofSeconds(((Integer)attributes.getNumber("maxInactiveIntervalInSeconds")).intValue());
        String sessionMapNameValue = attributes.getString("sessionMapName");
        if (StringUtils.hasText((String)sessionMapNameValue)) {
            this.sessionMapName = sessionMapNameValue;
        }
        this.flushMode = (FlushMode)attributes.getEnum("flushMode");
        this.saveMode = (SaveMode)attributes.getEnum("saveMode");
    }

    private HazelcastIndexedSessionRepository createHazelcastIndexedSessionRepository() {
        HazelcastIndexedSessionRepository sessionRepository = new HazelcastIndexedSessionRepository(this.hazelcastInstance);
        sessionRepository.setApplicationEventPublisher(this.applicationEventPublisher);
        if (this.indexResolver != null) {
            sessionRepository.setIndexResolver(this.indexResolver);
        }
        if (StringUtils.hasText((String)this.sessionMapName)) {
            sessionRepository.setSessionMapName(this.sessionMapName);
        }
        sessionRepository.setDefaultMaxInactiveInterval(this.maxInactiveInterval);
        sessionRepository.setFlushMode(this.flushMode);
        sessionRepository.setSaveMode(this.saveMode);
        this.sessionRepositoryCustomizers.forEach(sessionRepositoryCustomizer -> sessionRepositoryCustomizer.customize((SessionRepository)sessionRepository));
        return sessionRepository;
    }
}

