/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.hazelcast;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.EOFException;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import org.springframework.session.MapSession;

public class HazelcastSessionSerializer
implements StreamSerializer<MapSession> {
    private static final int SERIALIZER_TYPE_ID = 1453;

    public void write(ObjectDataOutput out, MapSession session) throws IOException {
        out.writeUTF(session.getOriginalId());
        out.writeUTF(session.getId());
        this.writeInstant(out, session.getCreationTime());
        this.writeInstant(out, session.getLastAccessedTime());
        this.writeDuration(out, session.getMaxInactiveInterval());
        for (String attrName : session.getAttributeNames()) {
            Object attrValue = session.getAttribute(attrName);
            if (attrValue == null) continue;
            out.writeUTF(attrName);
            out.writeObject(attrValue);
        }
    }

    private void writeInstant(ObjectDataOutput out, Instant instant) throws IOException {
        out.writeLong(instant.getEpochSecond());
        out.writeInt(instant.getNano());
    }

    private void writeDuration(ObjectDataOutput out, Duration duration) throws IOException {
        out.writeLong(duration.getSeconds());
        out.writeInt(duration.getNano());
    }

    public MapSession read(ObjectDataInput in) throws IOException {
        String originalId = in.readUTF();
        MapSession cached = new MapSession(originalId);
        cached.setId(in.readUTF());
        cached.setCreationTime(this.readInstant(in));
        cached.setLastAccessedTime(this.readInstant(in));
        cached.setMaxInactiveInterval(this.readDuration(in));
        try {
            while (true) {
                String attrName = in.readUTF();
                Object attrValue = in.readObject();
                cached.setAttribute(attrName, attrValue);
            }
        }
        catch (EOFException eOFException) {
            return cached;
        }
    }

    private Instant readInstant(ObjectDataInput in) throws IOException {
        long seconds = in.readLong();
        int nanos = in.readInt();
        return Instant.ofEpochSecond(seconds, nanos);
    }

    private Duration readDuration(ObjectDataInput in) throws IOException {
        long seconds = in.readLong();
        int nanos = in.readInt();
        return Duration.ofSeconds(seconds, nanos);
    }

    public int getTypeId() {
        return 1453;
    }

    public void destroy() {
    }
}

