/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.redis.config;

import java.util.Properties;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.session.data.redis.config.ConfigureRedisAction;

public class ConfigureNotifyKeyspaceEventsAction
implements ConfigureRedisAction {
    static final String CONFIG_NOTIFY_KEYSPACE_EVENTS = "notify-keyspace-events";

    @Override
    public void configure(RedisConnection connection) {
        boolean A;
        String notifyOptions = this.getNotifyOptions(connection);
        Object customizedNotifyOptions = notifyOptions;
        if (!((String)customizedNotifyOptions).contains("E")) {
            customizedNotifyOptions = (String)customizedNotifyOptions + "E";
        }
        if (!(A = ((String)customizedNotifyOptions).contains("A")) && !((String)customizedNotifyOptions).contains("g")) {
            customizedNotifyOptions = (String)customizedNotifyOptions + "g";
        }
        if (!A && !((String)customizedNotifyOptions).contains("x")) {
            customizedNotifyOptions = (String)customizedNotifyOptions + "x";
        }
        if (!notifyOptions.equals(customizedNotifyOptions)) {
            connection.serverCommands().setConfig(CONFIG_NOTIFY_KEYSPACE_EVENTS, (String)customizedNotifyOptions);
        }
    }

    private String getNotifyOptions(RedisConnection connection) {
        try {
            Properties config = connection.serverCommands().getConfig(CONFIG_NOTIFY_KEYSPACE_EVENTS);
            if (config.isEmpty()) {
                return "";
            }
            return config.getProperty(config.stringPropertyNames().iterator().next());
        }
        catch (InvalidDataAccessApiUsageException ex) {
            throw new IllegalStateException("Unable to configure Redis to keyspace notifications. See https://docs.spring.io/spring-session/docs/current/reference/html5/#api-redisindexedsessionrepository-sessiondestroyedevent", ex);
        }
    }
}

