/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.redis.config.annotation.web.server;

import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.session.MapSession;
import org.springframework.session.ReactiveSessionRepository;
import org.springframework.session.SaveMode;
import org.springframework.session.Session;
import org.springframework.session.SessionIdGenerator;
import org.springframework.session.UuidSessionIdGenerator;
import org.springframework.session.config.ReactiveSessionRepositoryCustomizer;
import org.springframework.session.config.annotation.web.server.SpringWebSessionConfiguration;
import org.springframework.session.data.redis.config.annotation.SpringSessionRedisConnectionFactory;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@Import(value={SpringWebSessionConfiguration.class})
public abstract class AbstractRedisWebSessionConfiguration<T extends ReactiveSessionRepository<? extends Session>> {
    private Duration maxInactiveInterval = MapSession.DEFAULT_MAX_INACTIVE_INTERVAL;
    private String redisNamespace = "spring:session";
    private SaveMode saveMode = SaveMode.ON_SET_ATTRIBUTE;
    private ReactiveRedisConnectionFactory redisConnectionFactory;
    private RedisSerializer<Object> defaultRedisSerializer = new JdkSerializationRedisSerializer();
    private List<ReactiveSessionRepositoryCustomizer<T>> sessionRepositoryCustomizers;
    private SessionIdGenerator sessionIdGenerator = UuidSessionIdGenerator.getInstance();

    public abstract T sessionRepository();

    public void setMaxInactiveInterval(Duration maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public void setRedisNamespace(String namespace) {
        Assert.hasText((String)namespace, (String)"namespace cannot be empty or null");
        this.redisNamespace = namespace;
    }

    public void setSaveMode(SaveMode saveMode) {
        Assert.notNull((Object)saveMode, (String)"saveMode cannot be null");
        this.saveMode = saveMode;
    }

    public Duration getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public String getRedisNamespace() {
        return this.redisNamespace;
    }

    public SaveMode getSaveMode() {
        return this.saveMode;
    }

    public SessionIdGenerator getSessionIdGenerator() {
        return this.sessionIdGenerator;
    }

    public RedisSerializer<Object> getDefaultRedisSerializer() {
        return this.defaultRedisSerializer;
    }

    @Autowired
    public void setRedisConnectionFactory(@SpringSessionRedisConnectionFactory ObjectProvider<ReactiveRedisConnectionFactory> springSessionRedisConnectionFactory, ObjectProvider<ReactiveRedisConnectionFactory> redisConnectionFactory) {
        ReactiveRedisConnectionFactory redisConnectionFactoryToUse = (ReactiveRedisConnectionFactory)springSessionRedisConnectionFactory.getIfAvailable();
        if (redisConnectionFactoryToUse == null) {
            redisConnectionFactoryToUse = (ReactiveRedisConnectionFactory)redisConnectionFactory.getObject();
        }
        this.redisConnectionFactory = redisConnectionFactoryToUse;
    }

    @Autowired(required=false)
    @Qualifier(value="springSessionDefaultRedisSerializer")
    public void setDefaultRedisSerializer(RedisSerializer<Object> defaultRedisSerializer) {
        this.defaultRedisSerializer = defaultRedisSerializer;
    }

    @Autowired(required=false)
    public void setSessionRepositoryCustomizer(ObjectProvider<ReactiveSessionRepositoryCustomizer<T>> sessionRepositoryCustomizers) {
        this.sessionRepositoryCustomizers = sessionRepositoryCustomizers.orderedStream().collect(Collectors.toList());
    }

    protected List<ReactiveSessionRepositoryCustomizer<T>> getSessionRepositoryCustomizers() {
        return this.sessionRepositoryCustomizers;
    }

    protected ReactiveRedisTemplate<String, Object> createReactiveRedisTemplate() {
        RedisSerializer keySerializer = RedisSerializer.string();
        JdkSerializationRedisSerializer defaultSerializer = this.defaultRedisSerializer != null ? this.defaultRedisSerializer : new JdkSerializationRedisSerializer();
        RedisSerializationContext serializationContext = RedisSerializationContext.newSerializationContext((RedisSerializer)defaultSerializer).key(keySerializer).hashKey(keySerializer).build();
        return new ReactiveRedisTemplate(this.redisConnectionFactory, serializationContext);
    }

    public ReactiveRedisConnectionFactory getRedisConnectionFactory() {
        return this.redisConnectionFactory;
    }

    @Autowired(required=false)
    public void setSessionIdGenerator(SessionIdGenerator sessionIdGenerator) {
        this.sessionIdGenerator = sessionIdGenerator;
    }
}

