/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.redis.config.annotation.web.http;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.session.FlushMode;
import org.springframework.session.IndexResolver;
import org.springframework.session.SaveMode;
import org.springframework.session.Session;
import org.springframework.session.SessionIdGenerator;
import org.springframework.session.SessionRepository;
import org.springframework.session.UuidSessionIdGenerator;
import org.springframework.session.data.redis.RedisIndexedSessionRepository;
import org.springframework.session.data.redis.config.ConfigureNotifyKeyspaceEventsAction;
import org.springframework.session.data.redis.config.ConfigureRedisAction;
import org.springframework.session.data.redis.config.annotation.web.http.AbstractRedisHttpSessionConfiguration;
import org.springframework.session.data.redis.config.annotation.web.http.EnableRedisIndexedHttpSession;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

@Configuration(proxyBeanMethods=false)
public class RedisIndexedHttpSessionConfiguration
extends AbstractRedisHttpSessionConfiguration<RedisIndexedSessionRepository>
implements EmbeddedValueResolverAware,
ImportAware {
    private String cleanupCron = "0 * * * * *";
    private ConfigureRedisAction configureRedisAction = new ConfigureNotifyKeyspaceEventsAction();
    private IndexResolver<Session> indexResolver;
    private ApplicationEventPublisher applicationEventPublisher;
    private Executor redisTaskExecutor;
    private Executor redisSubscriptionExecutor;
    private StringValueResolver embeddedValueResolver;
    private SessionIdGenerator sessionIdGenerator = UuidSessionIdGenerator.getInstance();

    @Override
    @Bean
    public RedisIndexedSessionRepository sessionRepository() {
        RedisTemplate<String, Object> redisTemplate = this.createRedisTemplate();
        RedisIndexedSessionRepository sessionRepository = new RedisIndexedSessionRepository((RedisOperations<String, Object>)redisTemplate);
        sessionRepository.setApplicationEventPublisher(this.applicationEventPublisher);
        if (this.indexResolver != null) {
            sessionRepository.setIndexResolver(this.indexResolver);
        }
        if (this.getDefaultRedisSerializer() != null) {
            sessionRepository.setDefaultSerializer(this.getDefaultRedisSerializer());
        }
        sessionRepository.setDefaultMaxInactiveInterval(this.getMaxInactiveInterval());
        if (StringUtils.hasText((String)this.getRedisNamespace())) {
            sessionRepository.setRedisKeyNamespace(this.getRedisNamespace());
        }
        sessionRepository.setFlushMode(this.getFlushMode());
        sessionRepository.setSaveMode(this.getSaveMode());
        sessionRepository.setCleanupCron(this.cleanupCron);
        int database = this.resolveDatabase();
        sessionRepository.setDatabase(database);
        sessionRepository.setSessionIdGenerator(this.sessionIdGenerator);
        this.getSessionRepositoryCustomizers().forEach(sessionRepositoryCustomizer -> sessionRepositoryCustomizer.customize((SessionRepository)sessionRepository));
        return sessionRepository;
    }

    @Bean
    public RedisMessageListenerContainer springSessionRedisMessageListenerContainer(RedisIndexedSessionRepository sessionRepository) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(this.getRedisConnectionFactory());
        if (this.redisTaskExecutor != null) {
            container.setTaskExecutor(this.redisTaskExecutor);
        }
        if (this.redisSubscriptionExecutor != null) {
            container.setSubscriptionExecutor(this.redisSubscriptionExecutor);
        }
        container.addMessageListener((MessageListener)sessionRepository, Arrays.asList(new ChannelTopic(sessionRepository.getSessionDeletedChannel()), new ChannelTopic(sessionRepository.getSessionExpiredChannel())));
        container.addMessageListener((MessageListener)sessionRepository, Collections.singletonList(new PatternTopic(sessionRepository.getSessionCreatedChannelPrefix() + "*")));
        return container;
    }

    @Bean
    public InitializingBean enableRedisKeyspaceNotificationsInitializer() {
        return new EnableRedisKeyspaceNotificationsInitializer(this.getRedisConnectionFactory(), this.configureRedisAction);
    }

    public void setCleanupCron(String cleanupCron) {
        this.cleanupCron = cleanupCron;
    }

    @Autowired(required=false)
    public void setConfigureRedisAction(ConfigureRedisAction configureRedisAction) {
        this.configureRedisAction = configureRedisAction;
    }

    @Autowired
    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Autowired(required=false)
    public void setIndexResolver(IndexResolver<Session> indexResolver) {
        this.indexResolver = indexResolver;
    }

    @Autowired(required=false)
    @Qualifier(value="springSessionRedisTaskExecutor")
    public void setRedisTaskExecutor(Executor redisTaskExecutor) {
        this.redisTaskExecutor = redisTaskExecutor;
    }

    @Autowired(required=false)
    @Qualifier(value="springSessionRedisSubscriptionExecutor")
    public void setRedisSubscriptionExecutor(Executor redisSubscriptionExecutor) {
        this.redisSubscriptionExecutor = redisSubscriptionExecutor;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        Map attributeMap = importMetadata.getAnnotationAttributes(EnableRedisIndexedHttpSession.class.getName());
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)attributeMap);
        if (attributes == null) {
            return;
        }
        this.setMaxInactiveInterval(Duration.ofSeconds(((Integer)attributes.getNumber("maxInactiveIntervalInSeconds")).intValue()));
        String redisNamespaceValue = attributes.getString("redisNamespace");
        if (StringUtils.hasText((String)redisNamespaceValue)) {
            this.setRedisNamespace(this.embeddedValueResolver.resolveStringValue(redisNamespaceValue));
        }
        this.setFlushMode((FlushMode)attributes.getEnum("flushMode"));
        this.setSaveMode((SaveMode)attributes.getEnum("saveMode"));
        String cleanupCron = attributes.getString("cleanupCron");
        if (StringUtils.hasText((String)cleanupCron)) {
            this.setCleanupCron(cleanupCron);
        }
    }

    private int resolveDatabase() {
        if (ClassUtils.isPresent((String)"io.lettuce.core.RedisClient", null) && this.getRedisConnectionFactory() instanceof LettuceConnectionFactory) {
            return ((LettuceConnectionFactory)this.getRedisConnectionFactory()).getDatabase();
        }
        if (ClassUtils.isPresent((String)"redis.clients.jedis.Jedis", null) && this.getRedisConnectionFactory() instanceof JedisConnectionFactory) {
            return ((JedisConnectionFactory)this.getRedisConnectionFactory()).getDatabase();
        }
        return 0;
    }

    @Autowired(required=false)
    public void setSessionIdGenerator(SessionIdGenerator sessionIdGenerator) {
        this.sessionIdGenerator = sessionIdGenerator;
    }

    static class EnableRedisKeyspaceNotificationsInitializer
    implements InitializingBean {
        private final RedisConnectionFactory connectionFactory;
        private final ConfigureRedisAction configure;

        EnableRedisKeyspaceNotificationsInitializer(RedisConnectionFactory connectionFactory, ConfigureRedisAction configure) {
            this.connectionFactory = connectionFactory;
            this.configure = configure;
        }

        public void afterPropertiesSet() {
            if (this.configure == ConfigureRedisAction.NO_OP) {
                return;
            }
            RedisConnection connection = this.connectionFactory.getConnection();
            try {
                this.configure.configure(connection);
            }
            finally {
                try {
                    connection.close();
                }
                catch (Exception ex) {
                    LogFactory.getLog(this.getClass()).error((Object)"Error closing RedisConnection", (Throwable)ex);
                }
            }
        }
    }
}

