/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.mongo;

import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.index.IndexOperations;
import org.springframework.lang.Nullable;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.Session;
import org.springframework.session.data.mongo.AbstractMongoSessionConverter;
import org.springframework.session.data.mongo.Assert;
import org.springframework.session.data.mongo.JdkMongoSessionConverter;
import org.springframework.session.data.mongo.MongoSession;
import org.springframework.session.data.mongo.MongoSessionUtils;
import org.springframework.session.events.SessionCreatedEvent;
import org.springframework.session.events.SessionDeletedEvent;
import org.springframework.session.events.SessionExpiredEvent;

public class MongoIndexedSessionRepository
implements FindByIndexNameSessionRepository<MongoSession>,
ApplicationEventPublisherAware,
InitializingBean {
    public static final int DEFAULT_INACTIVE_INTERVAL = 1800;
    public static final String DEFAULT_COLLECTION_NAME = "sessions";
    private static final Logger logger = LoggerFactory.getLogger(MongoIndexedSessionRepository.class);
    private final MongoOperations mongoOperations;
    private Integer maxInactiveIntervalInSeconds = 1800;
    private String collectionName = "sessions";
    private AbstractMongoSessionConverter mongoSessionConverter = new JdkMongoSessionConverter(Duration.ofSeconds(this.maxInactiveIntervalInSeconds.intValue()));
    private ApplicationEventPublisher eventPublisher;

    public MongoIndexedSessionRepository(MongoOperations mongoOperations) {
        this.mongoOperations = mongoOperations;
    }

    public MongoSession createSession() {
        MongoSession session = new MongoSession();
        if (this.maxInactiveIntervalInSeconds != null) {
            session.setMaxInactiveInterval(Duration.ofSeconds(this.maxInactiveIntervalInSeconds.intValue()));
        }
        this.publishEvent((ApplicationEvent)new SessionCreatedEvent((Object)this, (Session)session));
        return session;
    }

    public void save(MongoSession session) {
        this.mongoOperations.save((Object)Assert.requireNonNull(MongoSessionUtils.convertToDBObject(this.mongoSessionConverter, session), "convertToDBObject must not null!"), this.collectionName);
    }

    @Nullable
    public MongoSession findById(String id) {
        Document sessionWrapper = this.findSession(id);
        if (sessionWrapper == null) {
            return null;
        }
        MongoSession session = MongoSessionUtils.convertToSession(this.mongoSessionConverter, sessionWrapper);
        if (session != null && session.isExpired()) {
            this.publishEvent((ApplicationEvent)new SessionExpiredEvent((Object)this, (Session)session));
            this.deleteById(id);
            return null;
        }
        return session;
    }

    public Map<String, MongoSession> findByIndexNameAndIndexValue(String indexName, String indexValue) {
        return Optional.ofNullable(this.mongoSessionConverter.getQueryForIndex(indexName, indexValue)).map(query -> this.mongoOperations.find(query, Document.class, this.collectionName)).orElse(Collections.emptyList()).stream().map(dbSession -> MongoSessionUtils.convertToSession(this.mongoSessionConverter, dbSession)).collect(Collectors.toMap(MongoSession::getId, mapSession -> mapSession));
    }

    public void deleteById(String id) {
        Optional.ofNullable(this.findSession(id)).ifPresent(document -> {
            MongoSession session = MongoSessionUtils.convertToSession(this.mongoSessionConverter, document);
            if (session != null) {
                this.publishEvent((ApplicationEvent)new SessionDeletedEvent((Object)this, (Session)session));
            }
            this.mongoOperations.remove(document, this.collectionName);
        });
    }

    public void afterPropertiesSet() {
        IndexOperations indexOperations = this.mongoOperations.indexOps(this.collectionName);
        this.mongoSessionConverter.ensureIndexes(indexOperations);
    }

    @Nullable
    private Document findSession(String id) {
        return (Document)this.mongoOperations.findById((Object)id, Document.class, this.collectionName);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    private void publishEvent(ApplicationEvent event) {
        try {
            this.eventPublisher.publishEvent(event);
        }
        catch (Throwable ex) {
            logger.error("Error publishing " + event + ".", ex);
        }
    }

    public void setMaxInactiveIntervalInSeconds(Integer maxInactiveIntervalInSeconds) {
        this.maxInactiveIntervalInSeconds = maxInactiveIntervalInSeconds;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public void setMongoSessionConverter(AbstractMongoSessionConverter mongoSessionConverter) {
        this.mongoSessionConverter = mongoSessionConverter;
    }
}

