/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.mongo;

import com.mongodb.DBObject;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.index.Index;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexInfo;
import org.springframework.data.mongodb.core.index.IndexOperations;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.Session;
import org.springframework.session.data.mongo.AuthenticationParser;
import org.springframework.session.data.mongo.MongoSession;

public abstract class AbstractMongoSessionConverter
implements GenericConverter {
    private static final Log LOG = LogFactory.getLog(AbstractMongoSessionConverter.class);
    static final String EXPIRE_AT_FIELD_NAME = "expireAt";
    private static final String SPRING_SECURITY_CONTEXT = "SPRING_SECURITY_CONTEXT";

    protected abstract Query getQueryForIndex(String var1, Object var2);

    protected void ensureIndexes(IndexOperations sessionCollectionIndexes) {
        for (IndexInfo info : sessionCollectionIndexes.getIndexInfo()) {
            if (!EXPIRE_AT_FIELD_NAME.equals(info.getName())) continue;
            LOG.debug((Object)"TTL index on field expireAt already exists");
            return;
        }
        LOG.info((Object)"Creating TTL index on field expireAt");
        sessionCollectionIndexes.ensureIndex((IndexDefinition)new Index(EXPIRE_AT_FIELD_NAME, Sort.Direction.ASC).named(EXPIRE_AT_FIELD_NAME).expire(0L));
    }

    protected String extractPrincipal(Session expiringSession) {
        String resolvedPrincipal = AuthenticationParser.extractName(expiringSession.getAttribute(SPRING_SECURITY_CONTEXT));
        if (resolvedPrincipal != null) {
            return resolvedPrincipal;
        }
        return (String)expiringSession.getAttribute(FindByIndexNameSessionRepository.PRINCIPAL_NAME_INDEX_NAME);
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(DBObject.class, MongoSession.class));
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        if (DBObject.class.isAssignableFrom(sourceType.getType())) {
            return this.convert(new Document(((DBObject)source).toMap()));
        }
        if (Document.class.isAssignableFrom(sourceType.getType())) {
            return this.convert((Document)source);
        }
        return this.convert((MongoSession)source);
    }

    protected abstract DBObject convert(MongoSession var1);

    protected abstract MongoSession convert(Document var1);
}

