/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.gemfire.support;

import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.apache.geode.internal.cache.AbstractRegion;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public abstract class GemFireUtils {
    public static boolean close(Closeable obj) {
        if (obj != null) {
            try {
                obj.close();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isClient(@Nullable GemFireCache gemfireCache) {
        boolean client = gemfireCache instanceof ClientCache;
        return client &= !(gemfireCache instanceof GemFireCacheImpl) || ((GemFireCacheImpl)gemfireCache).isClient();
    }

    public static boolean isPeer(@Nullable GemFireCache gemFireCache) {
        return gemFireCache instanceof Cache && !GemFireUtils.isClient(gemFireCache);
    }

    public static boolean isLocal(@Nullable ClientRegionShortcut shortcut) {
        return shortcut != null && shortcut.name().toLowerCase().contains("local");
    }

    public static boolean isNonLocalClientRegion(@Nullable Region<?, ?> region) {
        return Optional.ofNullable(region).filter(GemFireUtils::isPoolConfiguredOrHasServerProxy).map(Region::getRegionService).filter(GemFireCache.class::isInstance).map(GemFireCache.class::cast).filter(GemFireUtils::isClient).isPresent();
    }

    private static boolean isPoolConfiguredOrHasServerProxy(@Nullable Region<?, ?> region) {
        return GemFireUtils.isPoolConfigured(region) || GemFireUtils.hasServerProxy(region);
    }

    private static boolean isPoolConfigured(@Nullable Region<?, ?> region) {
        return Optional.ofNullable(region).map(Region::getAttributes).map(RegionAttributes::getPoolName).filter(StringUtils::hasText).isPresent();
    }

    private static boolean hasServerProxy(@Nullable Region<?, ?> region) {
        return region instanceof AbstractRegion && ((AbstractRegion)region).hasServerProxy();
    }

    public static boolean isProxy(ClientRegionShortcut shortcut) {
        switch (shortcut) {
            case PROXY: {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isProxy(Region<?, ?> region) {
        RegionAttributes regionAttributes = region.getAttributes();
        DataPolicy regionDataPolicy = regionAttributes.getDataPolicy();
        if (DataPolicy.EMPTY.equals(regionDataPolicy)) return true;
        if (!Optional.ofNullable(regionDataPolicy).filter(DataPolicy.PARTITION::equals).map(it -> regionAttributes.getPartitionAttributes()).filter(partitionAttributes -> partitionAttributes.getLocalMaxMemory() <= 0).isPresent()) return false;
        return true;
    }

    public static boolean isProxy(RegionShortcut shortcut) {
        switch (shortcut) {
            case PARTITION_PROXY: 
            case PARTITION_PROXY_REDUNDANT: 
            case REPLICATE_PROXY: {
                return true;
            }
        }
        return false;
    }
}

