/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.gemfire.expiration.support;

import java.time.Duration;
import java.util.Optional;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.session.Session;
import org.springframework.session.data.gemfire.expiration.SessionExpirationPolicy;
import org.springframework.session.data.gemfire.expiration.config.SessionExpirationTimeoutAware;

public class IdleTimeoutSessionExpirationPolicy
implements SessionExpirationPolicy,
SessionExpirationTimeoutAware {
    protected static final Duration DEFAULT_IDLE_TIMEOUT = Duration.ofMinutes(30L);
    private Duration idleTimeout;

    public IdleTimeoutSessionExpirationPolicy() {
        this(DEFAULT_IDLE_TIMEOUT);
    }

    public IdleTimeoutSessionExpirationPolicy(@Nullable Duration idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    @Override
    public void setExpirationTimeout(@Nullable Duration idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    protected Optional<Duration> getIdleTimeout() {
        return Optional.ofNullable(this.idleTimeout);
    }

    @Override
    public Optional<Duration> determineExpirationTimeout(@NonNull Session session) {
        return this.getIdleTimeout().map(idleTimeout -> idleTimeout.minus(this.computeIdleTime(session)));
    }

    private Duration computeIdleTime(@NonNull Session session) {
        long idleTime = Math.max(System.currentTimeMillis() - session.getLastAccessedTime().toEpochMilli(), 0L);
        return Duration.ofMillis(idleTime);
    }
}

