/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.gemfire;

import java.util.HashMap;
import java.util.Map;
import org.apache.geode.cache.query.SelectResults;
import org.springframework.data.gemfire.GemfireOperations;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.session.Session;
import org.springframework.session.data.gemfire.AbstractGemFireOperationsSessionRepository;

public class GemFireOperationsSessionRepository
extends AbstractGemFireOperationsSessionRepository {
    protected static final String FIND_SESSIONS_BY_INDEX_NAME_AND_INDEX_VALUE_QUERY = "SELECT s FROM %1$s s WHERE s.attributes['%2$s'] = $1";
    protected static final String FIND_SESSIONS_BY_PRINCIPAL_NAME_QUERY = "SELECT s FROM %1$s s WHERE s.principalName = $1";

    public GemFireOperationsSessionRepository(GemfireOperations template) {
        super(template);
    }

    @NonNull
    public Session createSession() {
        return this.configure(AbstractGemFireOperationsSessionRepository.GemFireSession.create());
    }

    @Nullable
    public Session findById(String sessionId) {
        Session storedSession = (Session)this.getSessionsTemplate().get((Object)sessionId);
        if (storedSession != null) {
            storedSession = storedSession.isExpired() ? this.delete(storedSession) : this.touch(this.commit(this.registerInterest(this.configure(AbstractGemFireOperationsSessionRepository.GemFireSession.from(storedSession)))));
        }
        return storedSession;
    }

    public Map<String, Session> findByIndexNameAndIndexValue(String indexName, String indexValue) {
        SelectResults results = this.getSessionsTemplate().find(this.prepareQuery(indexName), new Object[]{indexValue});
        HashMap<String, Session> sessions = new HashMap<String, Session>(results.size());
        results.asList().forEach(session -> sessions.put(session.getId(), this.touch(this.commit(this.registerInterest(this.configure((Session)session))))));
        return sessions;
    }

    protected String prepareQuery(String indexName) {
        String fullyQualifiedRegionName = this.getSessionsRegionName();
        return PRINCIPAL_NAME_INDEX_NAME.equals(indexName) ? String.format(FIND_SESSIONS_BY_PRINCIPAL_NAME_QUERY, fullyQualifiedRegionName) : String.format(FIND_SESSIONS_BY_INDEX_NAME_AND_INDEX_VALUE_QUERY, fullyQualifiedRegionName, indexName);
    }

    public void save(@Nullable Session session) {
        if (this.isNonNullAndDirty(session)) {
            this.doSave(session);
        }
    }

    private boolean isDirty(@NonNull Session session) {
        return !(session instanceof AbstractGemFireOperationsSessionRepository.GemFireSession) || ((AbstractGemFireOperationsSessionRepository.GemFireSession)session).hasDelta();
    }

    private boolean isNonNullAndDirty(@Nullable Session session) {
        return session != null && this.isDirty(session);
    }

    void doSave(@NonNull Session session) {
        this.getSessionsTemplate().put((Object)session.getId(), (Object)AbstractGemFireOperationsSessionRepository.GemFireSession.from(session));
        this.commit(session);
    }

    public void deleteById(String sessionId) {
        this.handleDeleted(sessionId, (Session)this.getSessionsTemplate().remove((Object)sessionId));
    }
}

