/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.gemfire.config.annotation.web.http;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.ExpirationAction;
import org.apache.geode.cache.ExpirationAttributes;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.apache.geode.pdx.PdxSerializer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.CacheFactoryBean;
import org.springframework.data.gemfire.GemfireOperations;
import org.springframework.data.gemfire.GemfireTemplate;
import org.springframework.data.gemfire.IndexFactoryBean;
import org.springframework.data.gemfire.IndexType;
import org.springframework.data.gemfire.RegionAttributesFactoryBean;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.session.Session;
import org.springframework.session.data.gemfire.AbstractGemFireOperationsSessionRepository;
import org.springframework.session.data.gemfire.GemFireOperationsSessionRepository;
import org.springframework.session.data.gemfire.config.annotation.web.http.AbstractGemFireHttpSessionConfiguration;
import org.springframework.session.data.gemfire.config.annotation.web.http.EnableGemFireHttpSession;
import org.springframework.session.data.gemfire.config.annotation.web.http.support.GemFireCacheTypeAwareRegionFactoryBean;
import org.springframework.session.data.gemfire.config.annotation.web.http.support.SessionAttributesIndexFactoryBean;
import org.springframework.session.data.gemfire.config.annotation.web.http.support.SpringSessionGemFireConfigurer;
import org.springframework.session.data.gemfire.serialization.SessionSerializer;
import org.springframework.session.data.gemfire.serialization.data.provider.DataSerializableSessionSerializer;
import org.springframework.session.data.gemfire.serialization.data.support.DataSerializerSessionSerializerAdapter;
import org.springframework.session.data.gemfire.serialization.pdx.provider.PdxSerializableSessionSerializer;
import org.springframework.session.data.gemfire.serialization.pdx.support.ComposablePdxSerializer;
import org.springframework.session.data.gemfire.serialization.pdx.support.PdxSerializerSessionSerializerAdapter;
import org.springframework.session.data.gemfire.support.GemFireUtils;
import org.springframework.util.StringUtils;

@Configuration
public class GemFireHttpSessionConfiguration
extends AbstractGemFireHttpSessionConfiguration
implements ImportAware {
    public static final int DEFAULT_MAX_INACTIVE_INTERVAL_IN_SECONDS = (int)TimeUnit.MINUTES.toSeconds(30L);
    protected static final Class<Object> SESSION_REGION_KEY_CONSTRAINT = Object.class;
    protected static final Class<AbstractGemFireOperationsSessionRepository.GemFireSession> SESSION_REGION_VALUE_CONSTRAINT = AbstractGemFireOperationsSessionRepository.GemFireSession.class;
    public static final ClientRegionShortcut DEFAULT_CLIENT_REGION_SHORTCUT = ClientRegionShortcut.PROXY;
    public static final RegionShortcut DEFAULT_SERVER_REGION_SHORTCUT = RegionShortcut.PARTITION;
    public static final String DEFAULT_POOL_NAME = "gemfirePool";
    public static final String DEFAULT_SESSION_REGION_NAME = "ClusteredSpringSessions";
    public static final String SESSION_DATA_SERIALIZER_BEAN_NAME = "SessionDataSerializer";
    public static final String SESSION_PDX_SERIALIZER_BEAN_NAME = "SessionPdxSerializer";
    public static final String SESSION_SERIALIZER_BEAN_ALIAS = "SessionSerializerRegisteredBeanAlias";
    public static final String DEFAULT_SESSION_SERIALIZER_BEAN_NAME = "SessionPdxSerializer";
    public static final String[] DEFAULT_INDEXABLE_SESSION_ATTRIBUTES = new String[0];
    private int maxInactiveIntervalInSeconds = DEFAULT_MAX_INACTIVE_INTERVAL_IN_SECONDS;
    private ClientRegionShortcut clientRegionShortcut = DEFAULT_CLIENT_REGION_SHORTCUT;
    private RegionShortcut serverRegionShortcut = DEFAULT_SERVER_REGION_SHORTCUT;
    private String poolName = "gemfirePool";
    private String sessionRegionName = "ClusteredSpringSessions";
    private String sessionSerializerBeanName = "SessionPdxSerializer";
    private String[] indexableSessionAttributes = DEFAULT_INDEXABLE_SESSION_ATTRIBUTES;

    public void setClientRegionShortcut(ClientRegionShortcut shortcut) {
        this.clientRegionShortcut = shortcut;
    }

    protected ClientRegionShortcut getClientRegionShortcut() {
        return Optional.ofNullable(this.clientRegionShortcut).orElse(DEFAULT_CLIENT_REGION_SHORTCUT);
    }

    public void setIndexableSessionAttributes(String[] indexableSessionAttributes) {
        this.indexableSessionAttributes = indexableSessionAttributes;
    }

    protected String[] getIndexableSessionAttributes() {
        return Optional.ofNullable(this.indexableSessionAttributes).orElse(DEFAULT_INDEXABLE_SESSION_ATTRIBUTES);
    }

    public void setMaxInactiveIntervalInSeconds(int maxInactiveIntervalInSeconds) {
        this.maxInactiveIntervalInSeconds = maxInactiveIntervalInSeconds;
    }

    protected int getMaxInactiveIntervalInSeconds() {
        return this.maxInactiveIntervalInSeconds;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    protected String getPoolName() {
        return Optional.ofNullable(this.poolName).filter(StringUtils::hasText).orElse(DEFAULT_POOL_NAME);
    }

    public void setServerRegionShortcut(RegionShortcut shortcut) {
        this.serverRegionShortcut = shortcut;
    }

    protected RegionShortcut getServerRegionShortcut() {
        return Optional.ofNullable(this.serverRegionShortcut).orElse(DEFAULT_SERVER_REGION_SHORTCUT);
    }

    public void setSessionRegionName(String sessionRegionName) {
        this.sessionRegionName = sessionRegionName;
    }

    protected String getSessionRegionName() {
        return Optional.ofNullable(this.sessionRegionName).filter(StringUtils::hasText).orElse(DEFAULT_SESSION_REGION_NAME);
    }

    public void setSessionSerializerBeanName(String sessionSerializerBeanName) {
        this.sessionSerializerBeanName = sessionSerializerBeanName;
    }

    protected String getSessionSerializerBeanName() {
        return Optional.ofNullable(this.sessionSerializerBeanName).filter(StringUtils::hasText).orElse("SessionPdxSerializer");
    }

    protected boolean isUsingDataSerialization() {
        return SESSION_DATA_SERIALIZER_BEAN_NAME.equals(this.getSessionSerializerBeanName());
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        AnnotationAttributes enableGemFireHttpSessionAttributes = AnnotationAttributes.fromMap((Map)importMetadata.getAnnotationAttributes(EnableGemFireHttpSession.class.getName()));
        ClientRegionShortcut defaultClientRegionShortcut = (ClientRegionShortcut)enableGemFireHttpSessionAttributes.getEnum("clientRegionShortcut");
        this.setClientRegionShortcut(this.resolveProperty(this.clientRegionShortcutPropertyName(), ClientRegionShortcut.class, defaultClientRegionShortcut));
        String[] defaultIndexableSessionAttributes = enableGemFireHttpSessionAttributes.getStringArray("indexableSessionAttributes");
        this.setIndexableSessionAttributes(this.resolveProperty(this.indexableSessionAttributesPropertyName(), defaultIndexableSessionAttributes));
        Integer defaultMaxInactiveIntervalInSeconds = enableGemFireHttpSessionAttributes.getNumber("maxInactiveIntervalInSeconds").intValue();
        this.setMaxInactiveIntervalInSeconds(this.resolveProperty(this.maxInactiveIntervalInSecondsPropertyName(), defaultMaxInactiveIntervalInSeconds));
        String defaultPoolName = enableGemFireHttpSessionAttributes.getString("poolName");
        this.setPoolName(this.resolveProperty(this.poolNamePropertyName(), defaultPoolName));
        String defaultSessionRegionName = enableGemFireHttpSessionAttributes.getString("regionName");
        this.setSessionRegionName(this.resolveProperty(this.sessionRegionNamePropertyName(), defaultSessionRegionName));
        RegionShortcut defaultServerRegionShortcut = (RegionShortcut)enableGemFireHttpSessionAttributes.getEnum("serverRegionShortcut");
        this.setServerRegionShortcut(this.resolveProperty(this.serverRegionShortcutPropertyName(), RegionShortcut.class, defaultServerRegionShortcut));
        String defaultSessionSerializerBeanName = enableGemFireHttpSessionAttributes.getString("sessionSerializerBeanName");
        this.setSessionSerializerBeanName(this.resolveProperty(this.sessionSerializerBeanNamePropertyName(), defaultSessionSerializerBeanName));
        this.applySpringSessionGemFireConfigurer();
    }

    private Optional<SpringSessionGemFireConfigurer> resolveSpringSessionGemFireConfigurer() {
        try {
            return Optional.of(this.getApplicationContext().getBean(SpringSessionGemFireConfigurer.class));
        }
        catch (BeansException cause) {
            if (this.isCauseBecauseNoSpringSessionGemFireConfigurerPresent((Exception)((Object)cause))) {
                return Optional.empty();
            }
            throw cause;
        }
    }

    private boolean isCauseBecauseNoSpringSessionGemFireConfigurerPresent(Exception cause) {
        return !(cause instanceof NoUniqueBeanDefinitionException) && cause instanceof NoSuchBeanDefinitionException;
    }

    private void applySpringSessionGemFireConfigurer() {
        this.resolveSpringSessionGemFireConfigurer().ifPresent(configurer -> {
            this.setClientRegionShortcut(configurer.getClientRegionShortcut());
            this.setIndexableSessionAttributes(configurer.getIndexableSessionAttributes());
            this.setMaxInactiveIntervalInSeconds(configurer.getMaxInactiveIntervalInSeconds());
            this.setPoolName(configurer.getPoolName());
            this.setServerRegionShortcut(configurer.getServerRegionShortcut());
            this.setSessionRegionName(configurer.getRegionName());
            this.setSessionSerializerBeanName(configurer.getSessionSerializerBeanName());
        });
    }

    @PostConstruct
    public void init() {
        this.getBeanFactory().registerAlias(this.getSessionSerializerBeanName(), SESSION_SERIALIZER_BEAN_ALIAS);
    }

    @Bean
    BeanPostProcessor sessionSerializerConfigurationBeanPostProcessor() {
        return new BeanPostProcessor(){

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof CacheFactoryBean) {
                    SessionSerializer sessionSerializer = GemFireHttpSessionConfiguration.this.resolveSessionSerializer();
                    GemFireHttpSessionConfiguration.this.configureSerialization((CacheFactoryBean)bean, sessionSerializer);
                }
                return bean;
            }
        };
    }

    private SessionSerializer resolveSessionSerializer() {
        return (SessionSerializer)this.getApplicationContext().getBean(SESSION_SERIALIZER_BEAN_ALIAS, SessionSerializer.class);
    }

    private boolean isDataSerializerSessionSerializerAdapterPresent() {
        return !ArrayUtils.isEmpty((Object[])this.getApplicationContext().getBeanNamesForType(DataSerializerSessionSerializerAdapter.class));
    }

    private void configureSerialization(CacheFactoryBean cacheFactoryBean, SessionSerializer sessionSerializer) {
        if (sessionSerializer instanceof DataSerializer) {
            if (sessionSerializer instanceof DataSerializableSessionSerializer) {
                DataSerializableSessionSerializer.register();
            } else {
                DataSerializer.register(sessionSerializer.getClass());
            }
        } else if (sessionSerializer instanceof PdxSerializer) {
            cacheFactoryBean.setPdxSerializer(ComposablePdxSerializer.compose((PdxSerializer)sessionSerializer, cacheFactoryBean.getPdxSerializer()));
        } else {
            Optional.ofNullable(sessionSerializer).filter(it -> !this.isDataSerializerSessionSerializerAdapterPresent()).ifPresent(serializer -> cacheFactoryBean.setPdxSerializer(ComposablePdxSerializer.compose(new PdxSerializerSessionSerializerAdapter(sessionSerializer), cacheFactoryBean.getPdxSerializer())));
        }
    }

    @Bean(value={"SessionDataSerializer"})
    public Object sessionDataSerializer() {
        return new DataSerializableSessionSerializer();
    }

    @Bean(value={"SessionPdxSerializer"})
    public Object sessionPdxSerializer() {
        return new PdxSerializableSessionSerializer();
    }

    @Bean(name={"ClusteredSpringSessions"})
    public GemFireCacheTypeAwareRegionFactoryBean<Object, Session> sessionRegion(GemFireCache gemfireCache, @Qualifier(value="sessionRegionAttributes") RegionAttributes<Object, Session> sessionRegionAttributes) {
        GemFireCacheTypeAwareRegionFactoryBean<Object, Session> sessionRegion = new GemFireCacheTypeAwareRegionFactoryBean<Object, Session>();
        sessionRegion.setAttributes(sessionRegionAttributes);
        sessionRegion.setCache(gemfireCache);
        sessionRegion.setClientRegionShortcut(this.getClientRegionShortcut());
        sessionRegion.setPoolName(this.getPoolName());
        sessionRegion.setRegionName(this.getSessionRegionName());
        sessionRegion.setServerRegionShortcut(this.getServerRegionShortcut());
        return sessionRegion;
    }

    @Bean
    public RegionAttributesFactoryBean sessionRegionAttributes(GemFireCache gemfireCache) {
        RegionAttributesFactoryBean regionAttributes = new RegionAttributesFactoryBean();
        regionAttributes.setKeyConstraint(SESSION_REGION_KEY_CONSTRAINT);
        regionAttributes.setValueConstraint(SESSION_REGION_VALUE_CONSTRAINT);
        if (this.isExpirationAllowed(gemfireCache)) {
            regionAttributes.setStatisticsEnabled(true);
            regionAttributes.setEntryIdleTimeout(new ExpirationAttributes(Math.max(this.getMaxInactiveIntervalInSeconds(), 0), ExpirationAction.INVALIDATE));
        }
        return regionAttributes;
    }

    boolean isExpirationAllowed(GemFireCache gemfireCache) {
        return !(!GemFireUtils.isClient(gemfireCache) ? GemFireUtils.isProxy(this.getServerRegionShortcut()) : GemFireUtils.isProxy(this.getClientRegionShortcut()));
    }

    @Bean
    @DependsOn(value={"ClusteredSpringSessions"})
    public GemfireTemplate sessionRegionTemplate(GemFireCache gemfireCache) {
        return new GemfireTemplate(gemfireCache.getRegion(this.getSessionRegionName()));
    }

    @Bean
    public GemFireOperationsSessionRepository sessionRepository(@Qualifier(value="sessionRegionTemplate") GemfireOperations gemfireOperations) {
        GemFireOperationsSessionRepository sessionRepository = new GemFireOperationsSessionRepository(gemfireOperations);
        sessionRepository.setMaxInactiveIntervalInSeconds(this.getMaxInactiveIntervalInSeconds());
        sessionRepository.setUseDataSerialization(this.isUsingDataSerialization());
        return sessionRepository;
    }

    @Bean
    @DependsOn(value={"ClusteredSpringSessions"})
    public IndexFactoryBean principalNameIndex(GemFireCache gemfireCache) {
        IndexFactoryBean principalNameIndex = new IndexFactoryBean();
        principalNameIndex.setCache((RegionService)gemfireCache);
        principalNameIndex.setName("principalNameIndex");
        principalNameIndex.setExpression("principalName");
        principalNameIndex.setFrom(GemFireUtils.toRegionPath(this.getSessionRegionName()));
        principalNameIndex.setOverride(true);
        principalNameIndex.setType(IndexType.HASH);
        return principalNameIndex;
    }

    @Bean
    @DependsOn(value={"ClusteredSpringSessions"})
    public SessionAttributesIndexFactoryBean sessionAttributesIndex(GemFireCache gemfireCache) {
        SessionAttributesIndexFactoryBean sessionAttributesIndex = new SessionAttributesIndexFactoryBean();
        sessionAttributesIndex.setGemFireCache(gemfireCache);
        sessionAttributesIndex.setIndexableSessionAttributes(this.getIndexableSessionAttributes());
        sessionAttributesIndex.setRegionName(this.getSessionRegionName());
        return sessionAttributesIndex;
    }
}

