/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.jackson;

import org.jspecify.annotations.Nullable;
import org.springframework.security.web.webauthn.api.COSEAlgorithmIdentifier;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.deser.std.StdDeserializer;

class COSEAlgorithmIdentifierDeserializer
extends StdDeserializer<COSEAlgorithmIdentifier> {
    COSEAlgorithmIdentifierDeserializer() {
        super(COSEAlgorithmIdentifier.class);
    }

    public @Nullable COSEAlgorithmIdentifier deserialize(JsonParser parser, DeserializationContext ctxt) throws JacksonException {
        Long transportValue = (Long)parser.readValueAs(Long.class);
        for (COSEAlgorithmIdentifier identifier : COSEAlgorithmIdentifier.values()) {
            if (identifier.getValue() != transportValue.longValue()) continue;
            return identifier;
        }
        return null;
    }
}

