/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.jackson;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.jspecify.annotations.Nullable;
import org.springframework.security.web.webauthn.api.COSEAlgorithmIdentifier;

class COSEAlgorithmIdentifierDeserializer
extends StdDeserializer<COSEAlgorithmIdentifier> {
    COSEAlgorithmIdentifierDeserializer() {
        super(COSEAlgorithmIdentifier.class);
    }

    public @Nullable COSEAlgorithmIdentifier deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException, JacksonException {
        Long transportValue = (Long)parser.readValueAs(Long.class);
        for (COSEAlgorithmIdentifier identifier : COSEAlgorithmIdentifier.values()) {
            if (identifier.getValue() != transportValue.longValue()) continue;
            return identifier;
        }
        return null;
    }
}

